/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ConfigurationError;
import org.databene.commons.ConnectFailedException;
import org.databene.commons.ErrorHandler;
import org.databene.commons.IOUtil;
import org.databene.commons.ReaderLineIterator;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.db.LoggingPreparedStatementHandler;
import org.databene.commons.db.ResultsWithMetadata;
import org.databene.commons.db.SQLScriptException;

public class DBUtil {
    private static final Log logger = LogFactory.getLog(DBUtil.class);
    private static final Log jdbcLogger = LogFactory.getLog((String)"org.databene.JDBC");

    private DBUtil() {
    }

    public static Connection connect(String url, String driverClass, String user, String password) throws ConnectFailedException {
        try {
            Class.forName(driverClass);
            jdbcLogger.debug((Object)("opening connection to " + url));
            Connection connection = DriverManager.getConnection(url, user, password);
            return connection;
        }
        catch (Exception e) {
            throw new ConnectFailedException("Connecting " + url + " failed: ", e);
        }
    }

    public static boolean available(String url, String driverClass, String user, String password) {
        try {
            Connection connection = DBUtil.connect(url, driverClass, user, password);
            DBUtil.close(connection);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new ConfigurationError("Closing statement failed", e);
            }
        }
    }

    public static void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                throw new ConfigurationError("Closing statement failed", e);
            }
        }
    }

    public static Object parseResultSet(ResultSet resultSet) throws SQLException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (resultSet.next()) {
            int columnCount = resultSet.getMetaData().getColumnCount();
            Object[] cells = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                cells[i] = resultSet.getObject(i + 1);
            }
            rows.add(cells);
        }
        if (rows.size() == 1 && ((Object[])rows.get(0)).length == 1) {
            return ((Object[])rows.get(0))[0];
        }
        Object[][] array = new Object[rows.size()][];
        return rows.toArray((T[])array);
    }

    @Deprecated
    public static Object[] nextLine(ResultSet resultSet) throws SQLException {
        if (!resultSet.next()) {
            return null;
        }
        return DBUtil.currentLine(resultSet);
    }

    @Deprecated
    public static Object[] currentLine(ResultSet resultSet) throws SQLException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        Object[] cells = new Object[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            cells[i] = resultSet.getObject(i + 1);
        }
        return cells;
    }

    public static String format(ResultSet resultSet) throws SQLException {
        StringBuilder builder = new StringBuilder();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            builder.append(metaData.getColumnName(i)).append(i < columnCount ? ", " : SystemInfo.getLineSeparator());
        }
        Object parsed = DBUtil.parseResultSet(resultSet);
        if (parsed instanceof Object[][]) {
            for (Object[] row : (Object[][])parsed) {
                builder.append(ArrayFormat.format(", ", row)).append(SystemInfo.getLineSeparator());
            }
        } else {
            builder.append(ToStringConverter.convert(parsed, "null"));
        }
        return builder.toString();
    }

    public static String queryString(PreparedStatement statement) {
        try {
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new RuntimeException("Expected a row.");
            }
            String value = resultSet.getString(1);
            if (resultSet.next()) {
                throw new RuntimeException("Expected exactly one row, found more.");
            }
            resultSet.close();
            return value;
        }
        catch (SQLException e) {
            throw new RuntimeException("Database query failed: ", e);
        }
    }

    public static Object queryScalar(String query, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query);
            if (!resultSet.next()) {
                throw new RuntimeException("Expected a row.");
            }
            Object value = resultSet.getObject(1);
            if (resultSet.next()) {
                throw new RuntimeException("Expected exactly one row, found more.");
            }
            resultSet.close();
            statement.close();
            return value;
        }
        catch (SQLException e) {
            throw new RuntimeException("Database query failed: ", e);
        }
    }

    public static Object runScript(String scriptUri, String encoding, Connection connection, boolean ignoreComments, ErrorHandler errorHandler) throws IOException {
        BufferedReader reader = IOUtil.getReaderForURI(scriptUri, encoding);
        return DBUtil.runScript(reader, connection, ignoreComments, errorHandler);
    }

    public static Object runScript(String scriptText, Connection connection, boolean ignoreComments, ErrorHandler errorHandler) {
        StringReader reader = new StringReader(scriptText);
        return DBUtil.runScript(reader, connection, ignoreComments, errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object runScript(Reader reader, Connection connection, boolean ignoreComments, ErrorHandler errorHandler) {
        ReaderLineIterator iterator = new ReaderLineIterator(reader);
        Object exception = null;
        Object result = null;
        try {
            StringBuilder cmd = new StringBuilder();
            while (iterator.hasNext()) {
                block10: {
                    String sql;
                    String line = iterator.next().trim();
                    if (line.startsWith("--")) continue;
                    if (cmd.length() > 0) {
                        cmd.append('\n');
                    }
                    cmd.append(line);
                    if (!line.endsWith(";") && iterator.hasNext()) continue;
                    if (line.endsWith(";")) {
                        cmd.delete(cmd.length() - 1, cmd.length());
                    }
                    if (!((sql = cmd.toString().trim()).length() <= 0 || ignoreComments && StringUtil.startsWithIgnoreCase(sql, "COMMENT"))) {
                        try {
                            result = sql.toLowerCase().startsWith("select") ? DBUtil.query(sql, connection) : Integer.valueOf(DBUtil.executeUpdate(sql, connection));
                        }
                        catch (SQLException e) {
                            if (errorHandler == null) {
                                errorHandler = new ErrorHandler(DBUtil.class);
                            }
                            errorHandler.handleError("Error in executing SQL: " + SystemInfo.getLineSeparator() + cmd, e);
                            if (exception == null) break block10;
                            exception = new SQLScriptException(e, iterator.lineCount());
                        }
                    }
                }
                cmd.delete(0, cmd.length());
            }
            Object object = exception != null ? exception : result;
            return object;
        }
        finally {
            iterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, Connection connection) throws SQLException {
        if (sql == null || sql.trim().length() == 0) {
            logger.warn((Object)"Empty SQL string in executeUpdate()");
            return 0;
        }
        int result = 0;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            result = statement.executeUpdate(sql);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object query(String query, Connection connection) throws SQLException {
        Object object;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(query);
            object = DBUtil.parseResultSet(resultSet);
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close(statement);
            throw throwable;
        }
        DBUtil.close(resultSet);
        DBUtil.close(statement);
        return object;
    }

    public static PreparedStatement prepareStatement(Connection connection, String sql, boolean readOnly) throws SQLException {
        return DBUtil.prepareStatement(connection, sql, readOnly, 1003, 1007, 1);
    }

    public static PreparedStatement prepareStatement(Connection connection, String sql, boolean readOnly, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        jdbcLogger.debug((Object)("preparing statement: " + sql));
        DBUtil.checkReadOnly(sql, readOnly);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        PreparedStatement realStatement = connection.prepareStatement(sql);
        return (PreparedStatement)Proxy.newProxyInstance(classLoader, new Class[]{PreparedStatement.class}, (InvocationHandler)new LoggingPreparedStatementHandler(realStatement, sql));
    }

    public static String escape(String text) {
        return text.replace("'", "''");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultsWithMetadata queryWithMetadata(String query, Connection connection) throws SQLException {
        ResultsWithMetadata resultsWithMetadata;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(query);
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                columnNames[i - 1] = metaData.getColumnName(i);
            }
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (resultSet.next()) {
                String[] cells = new String[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    cells[i] = resultSet.getString(i + 1);
                }
                rows.add(cells);
            }
            String[][] array = new String[rows.size()][];
            resultsWithMetadata = new ResultsWithMetadata(columnNames, (String[][])rows.toArray((T[])array));
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close(statement);
            throw throwable;
        }
        DBUtil.close(resultSet);
        DBUtil.close(statement);
        return resultsWithMetadata;
    }

    public static void checkReadOnly(String sql, boolean readOnly) {
        if (readOnly && !sql.trim().toLowerCase().startsWith("select")) {
            throw new IllegalStateException("Tried to mutate a database with read-only settings: " + sql);
        }
    }
}

