/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.db;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDriverInfo {
    private static final String DB_DEFINITION_FILE = "org/databene/commons/db/jdbc-driver-info.xml";
    private String id;
    private String name;
    private String dbSystem;
    private String downloadUrl;
    private String driverClass;
    private String defaultDatabase;
    private String defaultSchema;
    private String defaultPort;
    private String urlPattern;
    private String defaultUser;
    private String[] jars;
    private boolean installed = false;
    private static HashMap<String, JDBCDriverInfo> instances = new HashMap();
    public static final JDBCDriverInfo HSQL;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = this.normalize(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = this.normalize(name);
    }

    public String getDbSystem() {
        return this.dbSystem;
    }

    public void setDbSystem(String dbSystem) {
        this.dbSystem = this.normalize(dbSystem);
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = this.normalize(urlPattern);
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = this.normalize(downloadUrl);
    }

    public String getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(String defaultPort) {
        this.defaultPort = this.normalize(defaultPort);
    }

    public String[] getJars() {
        return this.jars;
    }

    public void setJars(String[] jars) {
        this.jars = jars;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = this.normalize(driverClass);
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(String defaultUser) {
        this.defaultUser = this.normalize(defaultUser);
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public void setDefaultDatabase(String defaultDatabase) {
        this.defaultDatabase = this.normalize(defaultDatabase);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public boolean installed() {
        block3: {
            if (this.installed) {
                return true;
            }
            try {
                BeanUtil.forName(this.driverClass);
                this.installed = true;
            }
            catch (ConfigurationError e) {
                this.installed = false;
                if (e.getCause() instanceof ClassNotFoundException) break block3;
                throw e;
            }
        }
        return this.installed;
    }

    public String jdbcURL(String host, String port, String database) {
        return MessageFormat.format(this.urlPattern, host, port, database);
    }

    private String normalize(String value) {
        return value == null || value.trim().length() == 0 ? null : value.trim();
    }

    public static Collection<JDBCDriverInfo> getInstances() {
        return instances.values();
    }

    public static JDBCDriverInfo getInstance(String name) {
        return instances.get(name);
    }

    static {
        try {
            Element[] driverElements;
            Document document = XMLUtil.parse(DB_DEFINITION_FILE);
            Element root = document.getDocumentElement();
            for (Element driverElement : driverElements = XMLUtil.getChildElements(root)) {
                JDBCDriverInfo driver = new JDBCDriverInfo();
                driver.setId(driverElement.getAttribute("id"));
                driver.setName(driverElement.getAttribute("name"));
                driver.setDbSystem(driverElement.getAttribute("system"));
                driver.setDriverClass(driverElement.getAttribute("class"));
                driver.setDefaultPort(driverElement.getAttribute("port"));
                driver.setDefaultDatabase(driverElement.getAttribute("defaultDatabase"));
                driver.setDefaultSchema(driverElement.getAttribute("defaultSchema"));
                driver.setUrlPattern(driverElement.getAttribute("url"));
                driver.setDownloadUrl(driverElement.getAttribute("info"));
                driver.setDefaultUser(driverElement.getAttribute("user"));
                ArrayBuilder<String> builder = new ArrayBuilder<String>(String.class);
                for (Element dependencyElement : XMLUtil.getChildElements(driverElement, false, "dependency")) {
                    builder.append(dependencyElement.getAttribute("lib"));
                }
                driver.setJars(builder.toArray());
                instances.put(driver.getId(), driver);
            }
        }
        catch (IOException e) {
            throw new ConfigurationError("Unable to read database info file", e);
        }
        HSQL = JDBCDriverInfo.getInstance("HSQL");
    }
}

