/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.db;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Converter;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.ArrayConverter;
import org.databene.commons.converter.ToStringConverter;

public class LoggingPreparedStatementHandler
implements InvocationHandler {
    private static final Log sqlLogger = LogFactory.getLog((String)"org.databene.SQL");
    private static final Log jdbcLogger = LogFactory.getLog((String)"org.databene.JDBC");
    private static final Converter<Object[], String[]> toStringArrayConverter = new ArrayConverter<Object, String>(Object.class, String.class, new ToStringConverter("null"));
    private String sql;
    private PreparedStatement realStatement;
    Object[] params;

    public LoggingPreparedStatementHandler(PreparedStatement realStatement, String sql) {
        this.sql = sql;
        this.realStatement = realStatement;
        int paramCount = StringUtil.countChars(sql, '?');
        this.params = new Object[paramCount];
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String methodName = method.getName();
            Method localMethod = BeanUtil.findMethod(this.getClass(), methodName, method.getParameterTypes());
            if (localMethod != null) {
                return BeanUtil.invoke((Object)this, localMethod, args);
            }
            if ("setNull".equals(methodName) && args != null && args.length >= 2) {
                this.params[((Integer)args[0]).intValue() - 1] = null;
            } else if (methodName.startsWith("set") && args != null && args.length >= 2 && args[0] instanceof Integer) {
                this.params[((Integer)args[0]).intValue() - 1] = args[1];
            }
            return BeanUtil.invoke((Object)this.realStatement, method, args);
        }
        catch (ConfigurationError e) {
            if (e.getCause() instanceof InvocationTargetException && e.getCause().getCause() instanceof SQLException) {
                throw e.getCause().getCause();
            }
            throw e;
        }
    }

    public void addBatch() throws SQLException {
        this.logAll("addBatch", this.sql);
        this.realStatement.addBatch();
    }

    public void addBatch(String sql) throws SQLException {
        this.logAll("addBatch", sql);
        this.realStatement.addBatch(sql);
    }

    public boolean execute() throws SQLException {
        this.logAll("execute", this.sql);
        this.clearParams();
        return this.realStatement.execute();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.logAll("execute", sql);
        return this.realStatement.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.logAll("execute", sql);
        return this.realStatement.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.logAll("execute", sql);
        return this.realStatement.execute(sql, columnNames);
    }

    public boolean execute(String sql) throws SQLException {
        this.logAll("execute", sql);
        return this.realStatement.execute(sql);
    }

    public int[] executeBatch() throws SQLException {
        jdbcLogger.debug((Object)"executeBatch()");
        this.clearParams();
        return this.realStatement.executeBatch();
    }

    public ResultSet executeQuery() throws SQLException {
        this.logAll("executeQuery", this.sql);
        this.clearParams();
        return this.realStatement.executeQuery();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.logAll("executeQuery", sql);
        this.clearParams();
        return this.realStatement.executeQuery(sql);
    }

    public int executeUpdate() throws SQLException {
        this.logAll("executeUpdate", this.sql);
        this.clearParams();
        return this.realStatement.executeUpdate();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.logAll("executeUpdate", sql);
        return this.realStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.logAll("executeUpdate", sql);
        return this.realStatement.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.logAll("executeUpdate", sql);
        return this.realStatement.executeUpdate(sql, columnNames);
    }

    public int executeUpdate(String sql) throws SQLException {
        this.logAll("executeUpdate", sql);
        return this.realStatement.executeUpdate(sql);
    }

    private void clearParams() {
        this.params = new Object[this.params.length];
    }

    private void logAll(String method, String sql) {
        if (jdbcLogger.isDebugEnabled()) {
            jdbcLogger.debug((Object)(method + ": " + sql));
        }
        sqlLogger.debug((Object)this.toString());
    }

    public String toString() {
        String[] paramStrings = toStringArrayConverter.convert(this.params);
        return StringUtil.replaceTokens(this.sql, "?", paramStrings);
    }
}

