/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.db.hsql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.databene.commons.ConfigurationError;

public class HSQLUtil {
    public static final String IN_MEMORY_URL_PREFIX = "jdbc:hsqldb:mem:";
    public static final String DRIVER = "org.hsqldb.jdbcDriver";
    public static final String DEFAULT_USER = "sa";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_SCHEMA = "PUBLIC";

    public static Connection connectInMemoryDB(String dbName) throws SQLException {
        String driver = DRIVER;
        try {
            Class.forName(driver);
            String url = IN_MEMORY_URL_PREFIX + dbName;
            String user = DEFAULT_USER;
            String password = DEFAULT_PASSWORD;
            return DriverManager.getConnection(url, user, password);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationError("JDBC driver not found: " + driver, e);
        }
    }
}

