/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.file;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.databene.commons.ArrayUtil;
import org.databene.commons.TreeModel;
import org.databene.commons.file.FilenameComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTreeModel
implements TreeModel<File> {
    private File root;
    private Comparator<File> fileComparator;

    public FileTreeModel(File root) {
        this(root, new FilenameComparator());
    }

    public FileTreeModel(File root, Comparator<File> fileComparator) {
        if (!root.exists()) {
            throw new IllegalArgumentException("File/Directory not found: " + root);
        }
        this.root = root;
        this.fileComparator = fileComparator;
    }

    @Override
    public File getRoot() {
        return this.root;
    }

    @Override
    public File getParent(File child) {
        return child.getParentFile();
    }

    @Override
    public File getChild(File parent, int index) {
        return this.listFiles(parent)[index];
    }

    @Override
    public int getChildCount(File parent) {
        if (parent.isFile()) {
            return 0;
        }
        return this.listFiles(parent).length;
    }

    @Override
    public boolean isLeaf(File node) {
        return node.isFile();
    }

    @Override
    public int getIndexOfChild(File parent, File child) {
        File[] files = this.listFiles(parent);
        return ArrayUtil.indexOf(child, files);
    }

    private File[] listFiles(File parent) {
        File[] files = parent.listFiles();
        if (files != null) {
            Arrays.sort(files, this.fileComparator);
        } else {
            files = new File[]{};
        }
        return files;
    }
}

