/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.file;

import java.io.File;
import org.databene.commons.FileUtil;
import org.databene.commons.file.FileFilter;

public class MultiFileSuffixFilter
implements FileFilter {
    private String[] suffixes;
    private boolean caseSensitive;

    public MultiFileSuffixFilter(boolean caseSensitive, String ... suffixes) {
        this.suffixes = suffixes;
        this.caseSensitive = caseSensitive;
    }

    public boolean accept(File file) {
        for (String suffix : this.suffixes) {
            if (!FileUtil.hasSuffix(file, suffix, this.caseSensitive)) continue;
            return true;
        }
        return false;
    }
}

