/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.databene.commons.Element;
import org.databene.commons.Filter;
import org.databene.commons.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredFinder {
    public static <T> Collection<T> find(Element<T> root, Filter<T> filter) {
        HelperVisitor<T> visitor = new HelperVisitor<T>(filter);
        root.accept(visitor);
        return visitor.getMatches();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HelperVisitor<E>
    implements Visitor<E> {
        private Filter<E> filter;
        private List<E> matches;

        public HelperVisitor(Filter<E> filter) {
            this.filter = filter;
            this.matches = new ArrayList();
        }

        @Override
        public void visit(E element) {
            if (this.filter.accept(element)) {
                this.matches.add(element);
            }
        }

        public List<E> getMatches() {
            return this.matches;
        }
    }
}

