/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.filter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.databene.commons.BeanUtil;
import org.databene.commons.Condition;
import org.databene.commons.ExceptionMapper;
import org.databene.commons.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFilter<E, P>
implements Filter<E> {
    private Method propertyReadMethod;
    private Condition<P> propertyCondition;

    public PropertyFilter(Class<E> type, String propertyName, Condition<P> propertyCondition) {
        try {
            this.propertyReadMethod = type.getMethod(BeanUtil.readMethodName(propertyName, type), new Class[0]);
            this.propertyCondition = propertyCondition;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean accept(E candidate) {
        try {
            Object propertyValue = this.propertyReadMethod.invoke(candidate, new Object[0]);
            return this.propertyCondition.evaluate(propertyValue);
        }
        catch (IllegalAccessException e) {
            throw ExceptionMapper.configurationException((Exception)e, this.propertyReadMethod);
        }
        catch (InvocationTargetException e) {
            throw ExceptionMapper.configurationException((Exception)e, this.propertyReadMethod);
        }
    }
}

