/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.filter;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.Filter;
import org.databene.commons.filter.SplitResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Splitter {
    public static <T> SplitResult<T> split(T[] items, Filter<T> filter) {
        ArrayList<T> matches = new ArrayList<T>();
        ArrayList<T> mismatches = new ArrayList<T>();
        for (T item : items) {
            if (filter.accept(item)) {
                matches.add(item);
                continue;
            }
            mismatches.add(item);
        }
        return new SplitResult(matches, mismatches);
    }

    public static <T> List<List<T>> filter(T[] items, Filter<T> ... filters) {
        ArrayList<List<T>> results = new ArrayList<List<T>>(filters.length);
        for (int i = 0; i < filters.length; ++i) {
            results.add(new ArrayList());
        }
        for (T item : items) {
            for (int i = 0; i < filters.length; ++i) {
                Filter<T> filter = filters[i];
                if (!filter.accept(item)) continue;
                ((List)results.get(i)).add(item);
            }
        }
        return results;
    }
}

