/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.databene.commons.Converter;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.NumberConverter;
import org.databene.commons.format.TypedFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullSafeFormat<S>
extends TypedFormat<S> {
    private static final long serialVersionUID = -5865183253163042108L;
    private Format format;
    private Class<S> sourceType;
    private String nullString;
    private Converter<Number, S> reconverter;

    public NullSafeFormat(TypedFormat<S> format, String nullString) {
        this(format, format.getSourceType(), nullString);
    }

    public NullSafeFormat(Format format, Class<S> sourceType, String nullString) {
        this.format = format;
        this.sourceType = sourceType;
        this.nullString = nullString;
        this.reconverter = new NumberConverter<S>(sourceType);
    }

    @Override
    public Class<S> getSourceType() {
        return this.sourceType;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return new StringBuffer(this.nullString);
        }
        return this.format(obj, toAppendTo, pos);
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        return source != null ? super.parseObject(source) : null;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        int i;
        if (source == null) {
            return null;
        }
        for (i = pos.getIndex(); i < source.length() && StringUtil.isWhitespace(source.charAt(i)); ++i) {
        }
        if (source.substring(i).startsWith(this.nullString)) {
            pos.setIndex(i + this.nullString.length());
            return null;
        }
        Number number = (Number)this.format.parseObject(source, pos);
        return this.reconverter.convert(number);
    }
}

