/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import org.databene.commons.StringUtil;
import org.databene.commons.converter.Number2StringConverter;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.format.Alignment;

public class PadFormat
extends Format {
    private static final long serialVersionUID = 609871662377339019L;
    private int length;
    private int minimumFractionDigits;
    private int maximumFractionDigits;
    private Alignment alignment;
    private char padChar;

    public PadFormat(int length, Alignment alignment, char padChar) {
        this(length, 0, 2, alignment, padChar);
    }

    public PadFormat(int length, int fractionDigits, Alignment alignment, char padChar) {
        this(length, fractionDigits, fractionDigits, alignment, padChar);
    }

    public PadFormat(int length, int minimumFractionDigits, int maximumFractionDigits, Alignment alignment, char padChar) {
        assert (length >= 1);
        assert (minimumFractionDigits >= 0);
        assert (maximumFractionDigits >= 0);
        assert (alignment != null);
        assert (padChar != '\u0000');
        this.length = length;
        this.minimumFractionDigits = minimumFractionDigits;
        this.maximumFractionDigits = maximumFractionDigits;
        this.alignment = alignment;
        this.padChar = padChar;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        String text = obj instanceof Number ? Number2StringConverter.convert((Number)obj, this.minimumFractionDigits, this.maximumFractionDigits) : ToStringConverter.convert(obj, "");
        int padLength = this.length - text.length();
        switch (this.alignment) {
            case LEFT: {
                return toAppendTo.append(text).append(StringUtil.padString(this.padChar, padLength));
            }
            case RIGHT: {
                boolean neg;
                boolean bl = neg = this.padChar == '0' && text.length() > 0 && text.charAt(0) == '-';
                if (neg) {
                    return toAppendTo.append('-').append(StringUtil.padString(this.padChar, padLength)).append(text.substring(1));
                }
                return toAppendTo.append(StringUtil.padString(this.padChar, padLength)).append(text);
            }
            case CENTER: {
                return toAppendTo.append(StringUtil.padString(this.padChar, padLength / 2)).append(text).append(StringUtil.padString(this.padChar, padLength - padLength / 2));
            }
        }
        throw new IllegalArgumentException("Illegal Alignement: " + (Object)((Object)this.alignment));
    }

    public Object parseObject(String source, ParsePosition pos) {
        if (StringUtil.isEmpty(source)) {
            pos.setIndex(1);
        } else {
            pos.setIndex(source.length());
        }
        if (source == null) {
            return null;
        }
        switch (this.alignment) {
            case LEFT: {
                return StringUtil.trimRight(source, this.padChar);
            }
            case RIGHT: {
                boolean neg;
                boolean bl = neg = this.padChar == '0' && source.length() > 0 && source.charAt(0) == '-';
                if (neg) {
                    return '-' + StringUtil.trimLeft(source.substring(1), this.padChar);
                }
                return StringUtil.trimLeft(source, this.padChar);
            }
            case CENTER: {
                return StringUtil.trim(source, this.padChar);
            }
        }
        throw new IllegalArgumentException("Illegal Alignement: " + (Object)((Object)this.alignment));
    }

    public int getLength() {
        return this.length;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public char getPadChar() {
        return this.padChar;
    }

    public int hashCode() {
        return (((this.alignment.hashCode() * 31 + this.length) * 31 + this.minimumFractionDigits) * 31 + this.maximumFractionDigits) * 31 + this.padChar;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PadFormat that = (PadFormat)obj;
        return this.alignment.equals((Object)that.alignment) && this.length == that.length && this.minimumFractionDigits == that.minimumFractionDigits && this.maximumFractionDigits == that.maximumFractionDigits && this.padChar == that.padChar;
    }
}

