/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.iterator;

import junit.framework.Assert;
import org.databene.commons.iterator.BidirectionalIterator;
import org.databene.commons.iterator.IteratorTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BidirectionalIteratorTest
extends IteratorTest {
    public static <T> PreviousHelper expectPreviousElements(BidirectionalIterator<T> iterator, T ... elements) {
        for (T element : elements) {
            BidirectionalIteratorTest.assertTrue((boolean)iterator.hasPrevious());
            BidirectionalIteratorTest.assertEquals(element, iterator.previous());
        }
        return new PreviousHelper<T>(iterator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreviousHelper<T> {
        BidirectionalIterator<T> iterator;

        public PreviousHelper(BidirectionalIterator<T> iterator) {
            this.iterator = iterator;
        }

        public void withPrevious() {
            Assert.assertTrue((boolean)this.iterator.hasNext());
        }

        public void withNoPrevious() {
            Assert.assertFalse((boolean)this.iterator.hasPrevious());
        }
    }
}

