/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.iterator;

import org.databene.commons.iterator.BidirectionalIterator;
import org.databene.commons.iterator.IteratorProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicIterator<E>
extends IteratorProxy<E> {
    private boolean cyclic = true;

    public CyclicIterator(BidirectionalIterator<E> realIterator) {
        super(realIterator);
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public void setCyclic(boolean cyclic) {
        this.cyclic = cyclic;
    }

    @Override
    public boolean hasPrevious() {
        return this.cyclic || super.hasPrevious();
    }

    @Override
    public boolean hasNext() {
        return this.cyclic || super.hasNext();
    }

    @Override
    public E previous() {
        if (super.hasPrevious()) {
            return super.previous();
        }
        if (this.cyclic) {
            return super.last();
        }
        throw new IllegalStateException("No element available for previous()");
    }

    @Override
    public E next() {
        if (super.hasNext()) {
            return super.next();
        }
        if (this.cyclic) {
            return super.first();
        }
        throw new IllegalStateException("No element available for next()");
    }
}

