/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.iterator;

import java.util.Iterator;
import org.databene.commons.Filter;
import org.databene.commons.iterator.BidirectionalIterator;
import org.databene.commons.iterator.IteratorProxy;
import org.databene.commons.iterator.JDKIteratorWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringIterator<E>
extends IteratorProxy<E> {
    private Filter<E> filter;
    private E next;
    private E previous;

    public FilteringIterator(Iterator<E> realIterator, Filter<E> filter) {
        this(new JDKIteratorWrapper<E>(realIterator), filter);
    }

    public FilteringIterator(BidirectionalIterator<E> realIterator, Filter<E> filter) {
        super(realIterator);
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (super.hasNext()) {
            Object tmp = super.next();
            if (!this.filter.accept(tmp)) continue;
            this.next = tmp;
            return true;
        }
        return false;
    }

    @Override
    public E next() {
        if (this.next == null && !this.hasNext()) {
            throw new IllegalStateException("Nothing more to iterate");
        }
        E result = this.next;
        this.next = null;
        this.previous = null;
        return result;
    }

    @Override
    public E first() {
        this.next = null;
        this.previous = null;
        Object first = super.first();
        if (this.filter.accept(first)) {
            return first;
        }
        while (super.hasNext()) {
            Object tmp = super.next();
            if (!this.filter.accept(tmp)) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public boolean hasPrevious() {
        if (this.previous != null) {
            return true;
        }
        while (super.hasPrevious()) {
            Object tmp = super.previous();
            if (!this.filter.accept(tmp)) continue;
            this.previous = tmp;
            return true;
        }
        return false;
    }

    @Override
    public E previous() {
        if (this.previous == null && !this.hasPrevious()) {
            throw new IllegalStateException("Nothing more to iterate");
        }
        E result = this.previous;
        this.previous = null;
        this.next = null;
        return result;
    }

    @Override
    public E last() {
        this.next = null;
        this.previous = null;
        Object last = super.last();
        if (this.filter.accept(last)) {
            return last;
        }
        while (super.hasPrevious()) {
            Object tmp = super.previous();
            if (!this.filter.accept(tmp)) continue;
            return tmp;
        }
        return null;
    }
}

