/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.iterator;

import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IteratorTest
extends TestCase {
    public static <T> void checkUniqueIteration(Iterator<T> iterator, int count) {
        HashSet<T> items = new HashSet<T>(count);
        for (int i = 0; i < count; ++i) {
            IteratorTest.assertTrue((boolean)iterator.hasNext());
            T item = iterator.next();
            IteratorTest.assertFalse((boolean)items.contains(item));
            items.add(item);
        }
    }

    public static <T> NextHelper expectNextElements(Iterator<T> iterator, T ... elements) {
        for (T element : elements) {
            IteratorTest.assertTrue((boolean)iterator.hasNext());
            IteratorTest.assertEquals(element, iterator.next());
        }
        return new NextHelper<T>(iterator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NextHelper<T> {
        Iterator<T> iterator;

        public NextHelper(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        public void withNext() {
            Assert.assertTrue((boolean)this.iterator.hasNext());
        }

        public void withNoNext() {
            Assert.assertFalse((boolean)this.iterator.hasNext());
        }
    }
}

