/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.mutator;

import java.util.Map;
import org.databene.commons.BeanUtil;
import org.databene.commons.Context;
import org.databene.commons.Escalator;
import org.databene.commons.LoggerEscalator;
import org.databene.commons.Mutator;
import org.databene.commons.UpdateFailedException;
import org.databene.commons.accessor.FeatureAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyMutator<C, V>
implements Mutator<C, V> {
    private String path;
    private boolean strict;
    private static Escalator escalator = new LoggerEscalator();

    public AnyMutator(String path) {
        this(path, true);
    }

    public AnyMutator(String path, boolean strict) {
        this.path = path;
        this.strict = strict;
    }

    @Override
    public void setValue(C target, V value) throws UpdateFailedException {
        AnyMutator.setValue(target, this.path, value, this.strict);
    }

    public static <C, V> void setValue(C target, String path, V value) {
        AnyMutator.setValue(target, path, value, true);
    }

    public static <C, V> void setValue(C target, String path, V value, boolean strict) {
        int sep = path.indexOf(46);
        if (sep < 0) {
            AnyMutator.setLocal(target, path, value, strict);
        } else {
            String localName = path.substring(0, sep);
            Object subTarget = FeatureAccessor.getValue(target, localName);
            if (subTarget == null) {
                throw new IllegalStateException("No feature '" + localName + "' found in " + target);
            }
            String remainingName = path.substring(sep + 1);
            AnyMutator.setValue(subTarget, remainingName, value, strict);
        }
    }

    private static <C, V> void setLocal(C target, String featureName, V value, boolean strict) {
        if (target instanceof Context) {
            ((Context)target).set(featureName, value);
        } else if (target instanceof Map) {
            ((Map)target).put(featureName, value);
        } else if (BeanUtil.hasProperty(target.getClass(), featureName)) {
            BeanUtil.setPropertyValue(target, featureName, value, false);
        } else {
            String message = "No feature '" + featureName + "' found in " + target;
            if (strict) {
                throw new UnsupportedOperationException(message);
            }
            escalator.escalate(message, AnyMutator.class, null);
        }
    }
}

