/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.mutator;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.Accessor;
import org.databene.commons.ComparableComparator;
import org.databene.commons.Mutator;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.StringUtil;
import org.databene.commons.UpdateFailedException;
import org.databene.commons.mutator.MutatorProxy;

public class ConditionalMutator
extends MutatorProxy {
    public static final int ASSERT_EQUALS = 0;
    public static final int OVERWRITE = 1;
    public static final int SET_IF_UNDEFINED = 2;
    public static final int SET_IF_GREATER = 3;
    protected int mode;
    private Comparator comparator;
    private Accessor accessor;
    private static Log logger = LogFactory.getLog(ConditionalMutator.class);

    public ConditionalMutator(Mutator realMutator, Accessor accessor, int mode) {
        super(realMutator);
        this.accessor = accessor;
        this.mode = mode;
        this.comparator = new ComparableComparator();
    }

    public void setValue(Object target, Object value) throws UpdateFailedException {
        Object oldValue = this.accessor.getValue(target);
        switch (this.mode) {
            case 1: {
                this.realMutator.setValue(target, value);
                break;
            }
            case 0: {
                if (ConditionalMutator.isEmpty(oldValue)) {
                    this.realMutator.setValue(target, value);
                    break;
                }
                if (!NullSafeComparator.equals(oldValue, value)) {
                    throw new UpdateFailedException("Mutator " + this.realMutator + " expected '" + oldValue + "', " + "but found '" + value + "'");
                }
                logger.debug((Object)("no update needed by " + this.realMutator));
                break;
            }
            case 2: {
                if (ConditionalMutator.isEmpty(oldValue)) {
                    this.realMutator.setValue(target, value);
                    break;
                }
                logger.debug((Object)("no update needed by " + this.realMutator));
                break;
            }
            case 3: {
                if (ConditionalMutator.isEmpty(oldValue)) {
                    this.realMutator.setValue(target, value);
                    break;
                }
                if (this.comparator.compare(oldValue, value) == -1) {
                    this.realMutator.setValue(target, value);
                    break;
                }
                logger.debug((Object)("no update needed by " + this.realMutator));
                break;
            }
            default: {
                throw new RuntimeException("Illegal mode");
            }
        }
    }

    private static boolean isEmpty(Object value) {
        return value instanceof String ? StringUtil.isEmpty((String)value) : value == null;
    }
}

