/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.tree;

import java.util.HashMap;
import java.util.Map;
import org.databene.commons.TreeModel;
import org.databene.commons.tree.ChildModel;
import org.databene.commons.tree.DefaultChildModel;
import org.databene.commons.tree.DefaultTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildTreeModel<I, V>
implements TreeModel<V> {
    private ChildModel<I, V> childModel;
    private DefaultTreeNode<V> root;
    private Map<I, DefaultTreeNode<V>> elements;

    public ChildTreeModel() {
        this(new DefaultChildModel());
    }

    public ChildTreeModel(ChildModel<I, V> childModel) {
        this.childModel = childModel;
        this.elements = new HashMap<I, DefaultTreeNode<V>>();
    }

    public void add(V element) {
        DefaultTreeNode<V> elementNode;
        I id = this.childModel.getId(element);
        I parentId = this.childModel.getParentId(element);
        if (id == null) {
            elementNode = new DefaultTreeNode<V>(element);
            this.root = elementNode;
        } else {
            DefaultTreeNode<Object> parentNode = this.elements.get(parentId);
            if (parentNode == null) {
                if (this.root == null) {
                    parentNode = new DefaultTreeNode<Object>(null);
                    this.elements.put(parentId, parentNode);
                    this.root = parentNode;
                } else {
                    throw new IllegalArgumentException("Multiple roots.");
                }
            }
            elementNode = new DefaultTreeNode<V>(parentNode, element);
            parentNode.addChild(elementNode);
        }
        this.elements.put(id, elementNode);
    }

    @Override
    public V getRoot() {
        return this.root.getObject();
    }

    @Override
    public V getParent(V child) {
        return this.elements.get(this.childModel.getParentId(child)).getObject();
    }

    @Override
    public V getChild(V parent, int index) {
        return this.elements.get(this.childModel.getId(parent)).getChild(index).getObject();
    }

    @Override
    public int getChildCount(V parent) {
        return this.elements.get(this.childModel.getId(parent)).getChildCount();
    }

    @Override
    public boolean isLeaf(V node) {
        return this.elements.get(this.childModel.getId(node)).isLeaf();
    }

    @Override
    public int getIndexOfChild(V parent, V child) {
        return this.elements.get(this.childModel.getId(parent)).getIndexOfChild(new DefaultTreeNode<V>(child));
    }
}

