/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.tree;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeNode<E> {
    private DefaultTreeNode<E> parent;
    private boolean leaf;
    private List<DefaultTreeNode<E>> children;
    private E object;

    public static <T> DefaultTreeNode<T> createLeaf(DefaultTreeNode<T> parent, T object) {
        return new DefaultTreeNode<T>(parent, object, true);
    }

    public static <T> DefaultTreeNode<T> createFolder(DefaultTreeNode<T> parent, T object) {
        return new DefaultTreeNode<T>(parent, object, false);
    }

    public DefaultTreeNode(E object) {
        this(null, object);
    }

    public DefaultTreeNode(DefaultTreeNode<E> parent, E object) {
        this(parent, object, false);
    }

    public DefaultTreeNode(DefaultTreeNode<E> parent, E object, boolean leaf) {
        this.parent = parent;
        this.leaf = leaf;
        this.children = new ArrayList<DefaultTreeNode<E>>();
        this.object = object;
    }

    public void addChild(DefaultTreeNode<E> child) {
        if (this.leaf) {
            throw new IllegalStateException("Can't add a child to a leaf");
        }
        this.children.add(child);
    }

    public DefaultTreeNode<E> getParent() {
        return this.parent;
    }

    public DefaultTreeNode<E> getChild(int index) {
        return this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public int getIndexOfChild(DefaultTreeNode child) {
        return this.children.indexOf(child);
    }

    public E getObject() {
        return this.object;
    }

    public String toString() {
        return String.valueOf(this.object);
    }
}

