/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.tree;

import org.databene.commons.NullSafeComparator;
import org.databene.commons.TreeModel;
import org.databene.commons.iterator.BidirectionalIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeIterator<E>
implements BidirectionalIterator<E> {
    private TreeModel<E> treeModel;
    private E cursor;
    private Boolean hasNext;
    private E next;
    private Boolean hasPrevious;
    private E previous;

    public TreeIterator(TreeModel<E> treeModel) {
        this.treeModel = treeModel;
        this.cursor = treeModel.getRoot();
        this.hasNext = true;
        this.next = this.cursor;
        this.hasPrevious = null;
        this.previous = null;
    }

    @Override
    public E first() {
        this.cursor = this.treeModel.getRoot();
        this.hasNext = null;
        this.next = null;
        this.hasPrevious = null;
        this.previous = null;
        return this.cursor;
    }

    @Override
    public boolean hasPrevious() {
        if (this.hasPrevious == null) {
            this.previous = TreeIterator.nodeBefore(this.cursor, this.treeModel);
            this.hasPrevious = this.previous != null;
        }
        return this.hasPrevious;
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new IllegalStateException("No object available for previous()");
        }
        this.hasNext = true;
        this.next = this.cursor;
        this.cursor = this.previous;
        this.hasPrevious = null;
        this.previous = null;
        return this.cursor;
    }

    @Override
    public E last() {
        this.hasNext = false;
        this.next = null;
        this.hasPrevious = null;
        this.previous = null;
        E tmp = TreeIterator.lastChild(this.treeModel.getRoot(), this.treeModel);
        while (this.treeModel.getChildCount(tmp) > 0) {
            E candidate = TreeIterator.lastChild(tmp, this.treeModel);
            if (candidate == null) {
                this.cursor = tmp;
                return this.cursor;
            }
            tmp = candidate;
        }
        this.cursor = tmp;
        return this.cursor;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext == null) {
            this.next = TreeIterator.nodeAfter(this.cursor, this.treeModel);
            this.hasNext = this.next != null;
        }
        return this.hasNext;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No object available for next()");
        }
        this.hasPrevious = true;
        this.previous = this.cursor;
        this.cursor = this.next;
        this.hasNext = null;
        this.next = null;
        return this.cursor;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported on " + this.getClass());
    }

    private static <T> T nodeBefore(T cursor, TreeModel<T> treeModel) {
        if (cursor == treeModel.getRoot()) {
            return null;
        }
        T parent = treeModel.getParent(cursor);
        for (int i = treeModel.getIndexOfChild(parent, cursor); i > 0; --i) {
            T tmp = treeModel.getChild(parent, i - 1);
            if (treeModel.getChildCount(tmp) == 0) {
                return tmp;
            }
            T candidate = TreeIterator.lastSubNode(tmp, treeModel);
            if (candidate == null) continue;
            return candidate;
        }
        return parent;
    }

    private static <T> T lastChild(T node, TreeModel<T> treeModel) {
        int childCount = treeModel.getChildCount(node);
        if (childCount > 0) {
            return treeModel.getChild(node, childCount - 1);
        }
        return null;
    }

    private static <T> T lastSubNode(T node, TreeModel<T> treeModel) {
        T candidate = TreeIterator.lastChild(node, treeModel);
        while (candidate != null) {
            if (treeModel.getChildCount(candidate) == 0) {
                return candidate;
            }
            candidate = TreeIterator.lastChild(candidate, treeModel);
        }
        return null;
    }

    private static <T> T nodeAfter(T cursor, TreeModel<T> treeModel) {
        int cursorIndex;
        T tmp = null;
        if (treeModel.getChildCount(cursor) > 0) {
            tmp = treeModel.getChild(cursor, 0);
        }
        T parent = treeModel.getParent(cursor);
        if (tmp == null && parent != null && (cursorIndex = treeModel.getIndexOfChild(parent, cursor)) < treeModel.getChildCount(parent) - 1) {
            tmp = treeModel.getChild(parent, cursorIndex + 1);
        }
        while (tmp == null && parent != null && !NullSafeComparator.equals(parent, treeModel.getRoot())) {
            int parentLevelCount;
            T parentsParent = treeModel.getParent(parent);
            int parentsIndex = treeModel.getIndexOfChild(parentsParent, parent);
            if (parentsIndex < (parentLevelCount = treeModel.getChildCount(parentsParent)) - 1) {
                tmp = treeModel.getChild(parentsParent, parentsIndex + 1);
            }
            parent = parentsParent;
        }
        return tmp;
    }
}

