/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.ui;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.databene.commons.BeanUtil;
import org.databene.commons.Escalator;
import org.databene.commons.LoggerEscalator;

public class I18NSupport {
    private static final Escalator escalator = new LoggerEscalator();
    private String name;
    private ResourceBundle bundle;

    public I18NSupport(String name, Locale locale) {
        this.name = name;
        this.bundle = PropertyResourceBundle.getBundle(name, locale);
    }

    public String getName() {
        return this.name;
    }

    public Locale getLocale() {
        return this.bundle.getLocale();
    }

    public String getString(String resourceName) {
        String string;
        try {
            string = this.bundle.getString(resourceName);
        }
        catch (MissingResourceException e) {
            escalator.escalate("Resource not defined: " + resourceName, this, null);
            string = resourceName;
        }
        return string;
    }

    public String format(String resourceName, Object ... args) {
        return MessageFormat.format(this.getString(resourceName), args);
    }

    public String toString() {
        return BeanUtil.toString(this);
    }
}

