/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.validator;

import org.databene.commons.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLengthValidator
implements Validator<String> {
    private int minLength;
    private Integer maxLength;
    private boolean nullAllowed;

    public StringLengthValidator() {
        this(0, null);
    }

    public StringLengthValidator(int maxLength) {
        this(0, maxLength);
    }

    public StringLengthValidator(int minLength, Integer maxLength) {
        this.setMinLength(minLength);
        this.setMaxLength(maxLength);
    }

    public StringLengthValidator(int minLength, Integer maxLength, boolean nullAllowed) {
        this.setMinLength(minLength);
        this.setMaxLength(maxLength);
        this.setNullAllowed(nullAllowed);
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength may not be less than 0, but was: " + minLength);
        }
        this.minLength = minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    private void setNullAllowed(boolean nullAllowed) {
        this.nullAllowed = nullAllowed;
    }

    @Override
    public boolean valid(String text) {
        if (text == null) {
            return this.nullAllowed;
        }
        return text.length() >= this.minLength && (this.maxLength == null || text.length() <= this.maxLength);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append('[');
        if (this.minLength > 0) {
            builder.append(this.minLength).append("<=length");
        }
        if (this.maxLength != null) {
            if (this.minLength <= 0) {
                builder.append("length");
            }
            builder.append("<=").append(this.maxLength);
        }
        builder.append(']');
        return builder.toString();
    }
}

