/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.visitor;

import java.util.Comparator;
import org.databene.commons.ComparableComparator;
import org.databene.commons.Element;
import org.databene.commons.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtremeElementFinder<E> {
    public static <E> E findMax(Element<E> root) {
        return ExtremeElementFinder.findMax(root, new ComparableComparator());
    }

    public static <E> E findMax(Element<E> root, Comparator<E> comparator) {
        return ExtremeElementFinder.findExtreme(root, comparator, 1);
    }

    public static <E> E findMin(Element<E> root) {
        return ExtremeElementFinder.findMin(root, new ComparableComparator());
    }

    public static <E> E findMin(Element<E> root, Comparator<E> comparator) {
        return ExtremeElementFinder.findExtreme(root, comparator, -1);
    }

    private static <E> E findExtreme(Element<E> root, Comparator<E> comparator, int extreme) {
        ExtremeVisitor<E> visitor = new ExtremeVisitor<E>(comparator, extreme);
        root.accept(visitor);
        return (E)((ExtremeVisitor)visitor).extremeElement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExtremeVisitor<E>
    implements Visitor<E> {
        private Comparator<E> comparator;
        private int extreme;
        private E extremeElement;

        public ExtremeVisitor(Comparator<E> comparator, int extreme) {
            this.comparator = comparator;
            this.extreme = extreme;
            this.extremeElement = null;
        }

        @Override
        public void visit(E element) {
            if (this.extremeElement == null || this.comparator.compare(element, this.extremeElement) == this.extreme) {
                this.extremeElement = element;
            }
        }
    }
}

