/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.xml;

import java.util.HashMap;
import java.util.Map;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatXML2BeanConverter
extends FixedSourceTypeConverter<Element, Object> {
    private Map<String, Class<? extends Object>> types = new HashMap<String, Class<? extends Object>>();

    public FlatXML2BeanConverter() {
        super(Element.class, Object.class);
    }

    public void addMapping(String name, Class<? extends Object> type) {
        this.types.put(name, type);
    }

    @Override
    public Object convert(Element element) {
        String elementName = element.getNodeName();
        Class<? extends Object> type = this.types.get(elementName);
        if (type == null) {
            throw new ConfigurationError("Element type not mapped: " + elementName);
        }
        Object bean = BeanUtil.newInstance(type, new Object[0]);
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String propertyName = attribute.getName();
            String propertyValue = attribute.getValue();
            BeanUtil.setPropertyValue(bean, propertyName, propertyValue, false);
        }
        return bean;
    }
}

