/*
 * Decompiled with CFR 0.152.
 */
package org.databene.commons.xml;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.bean.BeanFactory;
import org.databene.commons.bean.ClassProvider;
import org.databene.commons.bean.DefaultClassProvider;
import org.databene.commons.converter.AnyConverter;
import org.databene.commons.converter.FixedSourceTypeConverter;
import org.databene.commons.converter.NoOpConverter;
import org.databene.commons.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElement2BeanConverter
extends FixedSourceTypeConverter<Element, Object> {
    private static final Log logger = LogFactory.getLog(XMLElement2BeanConverter.class);
    private static final ClassProvider DEFAULT_CLASS_PROVIDER = new DefaultClassProvider();
    private Context context;
    private Converter<? super String, Object> preprocessor;

    public XMLElement2BeanConverter() {
        this((Context)null);
    }

    public XMLElement2BeanConverter(Context context) {
        this(context, new NoOpConverter<Object>());
    }

    public XMLElement2BeanConverter(Context context, Converter<? super String, Object> preprocessor) {
        super(Element.class, Object.class);
        this.context = context;
        this.preprocessor = preprocessor;
    }

    @Override
    public Object convert(Element element) throws ConversionException {
        return XMLElement2BeanConverter.convert(element, this.context, this.preprocessor);
    }

    public static Object convert(Element element, Context context, Converter<? super String, Object> preprocessor) throws ConversionException {
        return XMLElement2BeanConverter.convert(element, context, preprocessor, DEFAULT_CLASS_PROVIDER);
    }

    public static Object convert(Element element, Context context, Converter<? super String, Object> preprocessor, ClassProvider factory) throws ConversionException {
        if ("idref".equals(element.getNodeName())) {
            if (context != null) {
                String id = element.getAttribute("bean");
                Object result = context.get(id);
                if (result == null) {
                    throw new IllegalStateException("Context does not contain an element of id '" + id + "'");
                }
                return result;
            }
            throw new IllegalArgumentException("'idref' without a Context");
        }
        return XMLElement2BeanConverter.convertBean(element, context, preprocessor, factory);
    }

    private static Object convertBean(Element element, Context context, Converter<? super String, Object> preprocessor, ClassProvider factory) throws ConversionException {
        String className = element.getAttribute("class");
        logger.debug((Object)("instantiating class '" + className + "'"));
        Class beanClass = factory.forName(className);
        NodeList propertyElements = element.getElementsByTagName("property");
        HashMap<String, Object> props = new HashMap<String, Object>(propertyElements.getLength());
        for (int i = 0; i < propertyElements.getLength(); ++i) {
            Object propertyValue;
            Element propertyElement = (Element)propertyElements.item(i);
            String propertyName = propertyElement.getAttribute("name");
            if (propertyElement.hasAttribute("value")) {
                propertyValue = preprocessor.convert(propertyElement.getAttribute("value"));
            } else if (propertyElement.hasAttribute("ref")) {
                String ref = String.valueOf(preprocessor.convert(propertyElement.getAttribute("ref")));
                propertyValue = context.get(ref);
            } else {
                NodeList childNodes = propertyElement.getChildNodes();
                ArrayList<Object> subElements = new ArrayList<Object>();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node node = childNodes.item(j);
                    if (!(node instanceof Element)) continue;
                    Element childElement = (Element)node;
                    subElements.add(XMLElement2BeanConverter.convert(childElement, context, preprocessor));
                }
                if (subElements.size() == 0) {
                    throw new ConfigurationError("No valid property spec in: " + XMLUtil.format(element));
                }
                PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(beanClass, propertyName);
                Class<?> propertyType = propertyDescriptor.getPropertyType();
                propertyValue = AnyConverter.convert(subElements, propertyType);
            }
            props.put(propertyName, propertyValue);
        }
        return BeanFactory.newBean(className, props, factory);
    }
}

