/*
 * Copyright (C) 2011-2015 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.databene.formats.token;

import org.databene.commons.Assert;

/**
 * TODO Document class.
 * Created: 10.04.2013 07:47:23
 * @since TODO version
 * @author Volker Bergmann
 */
public class Token<E extends Enum<E>> implements TextFragment {

	private E type;
	private int startOffset;
	private int endOffset;
	
	public Token(E type, int startOffset, int endOffset) {
		
		// check preconditions
		Assert.notNull(type, "tokenType");
		Assert.notNegative(startOffset, "startOffset");
		Assert.that(startOffset <= endOffset, "startOffset is greater that endOffset");
		
		// assign values
		this.type = type;
		this.startOffset = startOffset;
		this.endOffset = endOffset;
	}
	
	
	
	// properties ------------------------------------------------------------------------------------------------------
	
	public E getType() {
		return type;
	}

	@Override
	public int getStartOffset() {
		return startOffset;
	}

	@Override
	public int getEndOffset() {
		return endOffset;
	}
	
	public void move(int offset) {
		this.startOffset += offset;
		this.endOffset += offset;
	}

	
	
	// java.lang.overrides ---------------------------------------------------------------------------------------------

	@Override
	public int hashCode() {
		return 31 * (31 * endOffset + startOffset) + type.hashCode();
	}

	@Override
	public boolean equals(Object object) {
		if (this == object)
			return true;
		if (object == null || getClass() != object.getClass())
			return false;
		Token<?> that = (Token<?>) object;
		return (this.type == that.getType() && 
				this.endOffset == that.getEndOffset() && 
				this.startOffset == that.getStartOffset());
	}
	
	@Override
	public String toString() {
		return type + "(" + startOffset + "," + endOffset + ")";
	}

}
