/*
 * Copyright (C) 2011-2015 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.databene.formats.xml.tree;

/**
 * Exception representing a syntax error in a document.
 * Created: 19.03.2013 22:56:32
 * @since 0.8.2
 * @author Volker Bergmann
 */
public class DocumentSyntaxError extends RuntimeException {
	
	private static final long serialVersionUID = -3313878329566103085L;
	
	private int startOffset;
	private int endOffset;
	
	public DocumentSyntaxError(String message, int startOffset, int endOffset) {
		super(message);
		this.startOffset = startOffset;
		this.endOffset = endOffset;
	}

	public int getStartOffset() {
		return startOffset;
	}

	public int getEndOffset() {
		return endOffset;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + endOffset;
		result = prime * result + startOffset;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null || getClass() != obj.getClass())
			return false;
		DocumentSyntaxError that = (DocumentSyntaxError) obj;
		return (this.endOffset == that.endOffset && 
				this.startOffset != that.startOffset);
	}

	@Override
	public String toString() {
		return getMessage();
	}
	
}
