/*
 * Copyright (C) 2011-2015 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.databene.formats.xml.tree;

import static org.databene.formats.xml.tree.XMLTokenType.DECLARATION;
import static org.databene.formats.xml.tree.XMLTokenType.TAG_START;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * TODO Document class.
 * Created: 08.04.2013 07:46:35
 * @since TODO version
 * @author Volker Bergmann
 */
public class XMLParser {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(XMLParser.class);

	public XMLParser() {
	}
	
	public XMLParsingResult parse(XMLTokenIterator iterator) {
		XMLParsingResult result = new XMLParsingResult();
		// if the document is empty, then return
		if (iterator.peekNext() == null) {
			syntaxError("Empty text", 0, 0, result);
			return result;
		}
		
		// make sure there is no content before prolog
		boolean contentOccurred = false;
		while (iterator.peekNextType() != DECLARATION && iterator.peekNextType() != TAG_START && iterator.peekNextType() != null) {
			contentOccurred = true;
			iterator.next();
		}
		if (iterator.peekNextType() == DECLARATION && contentOccurred)
			syntaxError("No content allowed before prolog", 0, iterator.current().getEndOffset(), result);
		
		// proceed to start tag
		skipWhitespace(iterator);
		assertNextType(TAG_START, iterator, result);
		//parseElement(iterator, result);
		
		return result;
	}
	
	
	// private helper methods ------------------------------------------------------------------------------------------
	
	private void assertNextType(XMLTokenType expectedType, XMLTokenIterator iterator, XMLParsingResult result) {
		XMLToken token = iterator.peekNext();
		if (expectedType != token.getType())
			syntaxError(expectedType + " expected", token.getStartOffset(), token.getEndOffset(), result);
	}

	private void skipWhitespace(XMLTokenIterator iterator) {
		// TODO Auto-generated method stub
		
	}
/*
	private XMLElement parseElement(XMLTokenIterator iterator) {
		// parse tag start
		XMLToken st = iterator.next();
		XMLTokenType tagType = st.getType();
		if (tagType != TAG_START && tagType != END_TAG_START)
			syntaxError("'<' expected", st.getStartOffset(), st.getEndOffset(), result);
		
		// parse element name
		int index = startIndex + 1;
		XMLToken nt = tokenList.get(index);
		assertElementName(nt);
		String name = tokenList.getText(nt);
		index++;
		
		XMLElement element = new XMLElement(name, nt);
		element.setEndOffset(nt.getEndOffset());
		if (tagType != END_TAG_START)
			index = parseOptionalAttributes(element, index);
		
		XMLToken et = tokenList.get(index);
		if (et.getType() != TAG_END && et.getType() != CLOSED_TAG_END)
			syntaxError("Tag end expected", et.getStartOffset(), et.getEndOffset());
		else
			element.setEndOffset(et.getEndOffset());
		index++;
		
		if (et.getType() == TAG_END) {
			index = parseSubNodes(element, index);
			index = assertEndTag(element, index);
		}
		return element;
	}

	private int parseOptionalAttributes(XMLElement element, int index) {
		boolean done = false;
		do { 
			index = skipWhitespace(index);
			XMLToken token = tokenList.get(index);
			XMLTokenType type = token.getType();
			if (type == ATTRIBUTE_NAME)
				index = parseOptionalAttribute(element, index);
			else 
				done = true;
			if (type != ATTRIBUTE_NAME && type != TAG_END && type != CLOSED_TAG_END)
				syntaxError("'>' or '/>' expected", token.getStartOffset(), token.getStartOffset() + 1);
		} while (!done);
		return index;
	}

	private int parseOptionalAttribute(XMLElement element, int index) {
		XMLToken nameToken = tokenList.get(index);
		if (nameToken.getType() != ATTRIBUTE_NAME)
			syntaxError("Expected attribute name", nameToken.getStartOffset(), nameToken.getStartOffset() + 1);
		else {
			element.setEndOffset(nameToken.getEndOffset());
			index++;
			String name = tokenList.getText(nameToken);
			index = skipWhitespace(index);
			assertTokenType(ATTRIBUTE_EQUALS, tokenList.get(index));
			index++;
			index = skipWhitespace(index);
			XMLToken valueToken = tokenList.get(index);
			if (valueToken.getType() != SINGLE_QUOTED_STRING && valueToken.getType() != DOUBLE_QUOTED_STRING) {
				syntaxError("Quoted string expected", valueToken.getStartOffset(), valueToken.getEndOffset());
				return index;
			} else {
				element.setEndOffset(valueToken.getEndOffset());
				String value = tokenList.getText(valueToken);
				value = value.substring(1, value.length() - 1);
				element.setAttribute(name, value);
				index++;
				index = skipWhitespace(index);
			}
		}
		return index;
	}

	private int skipWhitespace(int index) {
		while (tokenList.get(index).getType() == WHITESPACE)
			index++;
		return index;
	}

	private int parseSubNodes(XMLElement element, int index) {
		boolean done = false;
		do {
			XMLToken token = tokenList.get(index);
			XMLTokenType type = token.getType();
			if (type == TAG_START) {
				element.addChild(parseElement(index));
				// TODO advance index
			} else if (type != TAG_END) {
				element.addChild(new XMLLeafNode(token));
				index++;
			} else {
				done = false;
			}
		} while (!done);
		return index;
	}

	private int assertEndTag(XMLElement element, int index) {
		XMLToken token = tokenList.get(index);
		if (token.getType() != END_TAG_START) {
			syntaxError("'</' expected", token.getStartOffset(), token.getEndOffset());
		} else {
			element.setEndOffset(token.getEndOffset());
			index++;
			XMLToken nameToken = tokenList.get(index);
			if (nameToken.getType() != ELEMENT_NAME) {
				syntaxError("element name expected", nameToken.getStartOffset(), nameToken.getEndOffset());
				if (!tokenList.getText(nameToken).equals(element.getName()))
					syntaxError("'" + element.getName() + "' expected", nameToken.getStartOffset(), nameToken.getEndOffset());
			} else {
				element.setEndOffset(nameToken.getEndOffset());
				index++;
				token = tokenList.get(index);
				if (token.getType() != TAG_END) {
					syntaxError("'>' expected", token.getStartOffset(), token.getEndOffset());
				} else {
					element.setEndOffset(token.getEndOffset());
					index++;
				}
			}
		}
		return index;
	}

	private int assertTokenTypeSequence(int index, XMLTokenType... types) {
		for (XMLTokenType type : types) {
			if (tokenList.get(index).getType() != type)
				syntaxError(type.getDescription() + " expected", tokenList.get(index).getStartOffset(), tokenList.get(index).getEndOffset());
			else
				index++;
		}
		return index;
	}

	private void assertElementName(XMLToken token) {
		if (token.getType() != ELEMENT_NAME)
			syntaxError("element name expected", token.getStartOffset(), token.getEndOffset());
	}

	private void assertTokenType(XMLTokenType expectedType, XMLToken actualToken) {
		if (actualToken.getType() != expectedType)
			syntaxError(expectedType.getDescription() + " name expected", actualToken.getStartOffset(), actualToken.getEndOffset());
	}

	private int firstElementTokenIndex() {
		for (int i = 0; i < tokenList.size(); i++)
			if (tokenList.get(i).getType().isElementToken())
				return i;
		return -1;
	}

	private int indexOf(XMLTokenType type) {
		for (int i = 0; i < tokenList.size(); i++)
			if (tokenList.get(i).getType() == type)
				return i;
		return -1;
	}
*/
	private void syntaxError(String message, int startOffset, int endOffset, XMLParsingResult result) {
		LOGGER.debug("{} from {} to {}", new Object[] { message, startOffset, endOffset });
		result.addSyntaxError(new DocumentSyntaxError(message, startOffset, endOffset));
	}
	
	
	
	// cursor operations -----------------------------------------------------------------------------------------------
/*
	private XMLToken current() {
		return iterator.current();
	}

	private XMLToken next() {
		return iterator.next();
	}

	private XMLTokenType peekNextType() {
		XMLToken next = iterator.peekNext();
		return (next != null ? next.getType() : null);
	}
*/
}
