/*
 * Copyright (C) 2011-2015 Volker Bergmann (volker.bergmann@bergmann-it.de).
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.databene.formats.xml.tree;

/**
 * Enumeration of XML token types.
 * Created: 19.03.2013 20:09:52
 * @since 0.8.2
 * @author Volker Bergmann
 */
public enum XMLTokenType {
	TAG_START("'<'", true),						// '<'
	TAG_END("'>'", true),						// '>'
	END_TAG_START("'</'", true),				// '</'
	CLOSED_TAG_END("'/>'", true),				// '/>'
	ELEMENT_NAME("element name", true),			// TODO doc
	WHITESPACE("whitespace", false),			//, space, tab or so
	ATTRIBUTE_NAME("attribute name", true),		// TODO doc
	ATTRIBUTE_EQUALS("'='", true),				// '='
	SINGLE_QUOTED_STRING("'", true),			// "'"
	DOUBLE_QUOTED_STRING("\"", true),			// '"'
	CHARS("text", false),						// text
	COMMENT("comment", false),					// <!-- -->
	CDATA("CDATA", false),						// <![CDATA[ ]]
	DECLARATION("DECLATARION", false);			// <? ?>
	
	private String description;
	private boolean elementToken;
	
	XMLTokenType(String description, boolean elemenToken) {
		this.elementToken = elemenToken;
	}
	
	public boolean isElementToken() {
		return this.elementToken;
	}
	
	public String getDescription() {
		return description;
	}
	
}
