/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.compare;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.formats.compare.ComparisonSettings;
import org.databene.formats.compare.DiffDetail;

public class AggregateDiff {
    private Object expected;
    private Object actual;
    private ComparisonSettings comparisonSettings;
    private List<DiffDetail> details;

    public AggregateDiff(Object expected, Object actual, ComparisonSettings comparisonSettings) {
        this.expected = expected;
        this.actual = actual;
        this.comparisonSettings = comparisonSettings;
        this.details = new ArrayList<DiffDetail>();
    }

    public Object getExpected() {
        return this.expected;
    }

    public Object getActual() {
        return this.actual;
    }

    public ComparisonSettings getComparisonSettings() {
        return this.comparisonSettings;
    }

    public boolean isEmpty() {
        return this.details.isEmpty();
    }

    public List<DiffDetail> getDetails() {
        return this.details;
    }

    public int getDetailCount() {
        return this.details.size();
    }

    public DiffDetail getDetail(int index) {
        return this.details.get(index);
    }

    public void addDetail(DiffDetail diff) {
        this.details.add(diff);
    }

    public String toString() {
        String LF = SystemInfo.getLineSeparator();
        StringBuilder builder = new StringBuilder("Aggregate diff:");
        if (this.details.isEmpty()) {
            builder.append(" Empty");
        } else {
            builder.append(LF);
            for (DiffDetail detail : this.details) {
                builder.append("- ").append(StringUtil.normalizeSpace((String)detail.toString())).append(LF);
            }
        }
        return builder.toString();
    }
}

