/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.compare;

import org.databene.commons.Assert;
import org.databene.commons.ProgrammerError;
import org.databene.formats.compare.ArrayComparisonResult;
import org.databene.formats.compare.ComparisonModel;
import org.databene.formats.compare.DiffFactory;

public class ArrayComparator {
    private static final int IDENTICAL = 0;
    private static final int CHANGED = 1;
    private static final int REMOVED = 2;
    private static final int ADDED = 3;
    private String parentLocator1;
    private String parentLocator2;
    private Object[] array1;
    private Object[] array2;
    private ComparisonModel model;
    private Match[] matches1;
    private Match[] matches2;
    private DiffFactory diffFactory;

    public static ArrayComparisonResult compare(Object[] array1, Object[] array2, ComparisonModel model, String parentLocator1, String parentLocator2, DiffFactory diffFactory) {
        return new ArrayComparator(array1, array2, model, parentLocator1, parentLocator2, diffFactory).compare();
    }

    private ArrayComparator(Object[] array1, Object[] array2, ComparisonModel model, String parentLocator1, String parentLocator2, DiffFactory diffFactory) {
        this.array1 = array1;
        this.array2 = array2;
        this.model = model;
        this.parentLocator1 = parentLocator1;
        this.parentLocator2 = parentLocator2;
        this.matches1 = new Match[array1.length];
        this.matches2 = new Match[array2.length];
        this.diffFactory = diffFactory;
    }

    private ArrayComparisonResult compare() {
        int i2;
        Object e1;
        int i1;
        for (i1 = 0; i1 < this.array1.length; ++i1) {
            e1 = this.array1[i1];
            if (i1 < this.array2.length && this.model.equal(e1, this.array2[i1])) {
                this.matches1[i1] = this.matches2[i1] = new Match(i1, i1, 0);
                continue;
            }
            i2 = this.indexOf(e1, this.array2, this.matches2);
            if (i2 < 0) continue;
            this.matches1[i1] = this.matches2[i2] = new Match(i1, i2, 0);
        }
        for (i1 = 0; i1 < this.array1.length; ++i1) {
            if (this.matches1[i1] != null) continue;
            e1 = this.array1[i1];
            i2 = this.indexOfSimilar(e1, this.array2, this.matches2);
            this.matches1[i1] = i2 >= 0 ? (this.matches2[i2] = new Match(i1, i2, 1)) : new Match(i1, -1, 2);
        }
        for (int i22 = 0; i22 < this.array2.length; ++i22) {
            if (this.matches2[i22] != null) continue;
            this.matches2[i22] = new Match(-1, i22, 3);
        }
        ArrayComparisonResult result = new ArrayComparisonResult();
        int i12 = 0;
        i2 = 0;
        while (i12 < this.array1.length || i2 < this.array2.length) {
            Match match2;
            Match match1 = i12 < this.matches1.length ? this.matches1[i12] : null;
            Match match = match2 = i2 < this.matches2.length ? this.matches2[i2] : null;
            if (match1 != null && match1.type == 2) {
                Object missingObject = this.array1[match1.i1];
                result.add(this.diffFactory.missing(missingObject, this.model.classifierOf(missingObject), this.locator1(this.array1, match1.i1)));
                match1.consume();
                i12 = ArrayComparator.nextUnconsumed(this.matches1, i12);
                continue;
            }
            if (match2 != null && match2.type == 3) {
                Object newObject = this.array2[match2.i2];
                result.add(this.diffFactory.unexpected(newObject, this.model.classifierOf(newObject), this.locator2(this.array2, match2.i2)));
                match2.consume();
                i2 = ArrayComparator.nextUnconsumed(this.matches2, i2);
                continue;
            }
            Assert.notNull((Object)match1, (String)"match1");
            Assert.notNull((Object)match2, (String)"match2");
            switch (match1.type) {
                case 1: {
                    Object changedObject = this.array1[match1.i1];
                    String classifier = this.model.classifierOf(changedObject);
                    if (match1.i1 != i12 || match1.i2 != i2) {
                        result.add(this.diffFactory.moved(this.array1[match1.i1], classifier, this.locator1(this.array1, match1.i1), this.locator2(this.array2, match1.i2)));
                    }
                    result.add(this.diffFactory.different(this.array1[match1.i1], this.array2[match1.i2], classifier, this.locator1(this.array1, match1.i1), this.locator2(this.array2, match1.i2)));
                    break;
                }
                case 0: {
                    if (match1.i1 == match1.i2 || match1.i1 == i12 && match1.i2 == i2) break;
                    Object movedObject = this.array1[match1.i1];
                    result.add(this.diffFactory.moved(movedObject, this.model.classifierOf(movedObject), this.locator1(this.array1, match1.i1), this.locator2(this.array1, match1.i2)));
                    break;
                }
                default: {
                    throw new ProgrammerError();
                }
            }
            match1.consume();
            this.matches2[match1.i2].consume();
            i12 = ArrayComparator.nextUnconsumed(this.matches1, i12);
            i2 = ArrayComparator.nextUnconsumed(this.matches2, i2);
        }
        return result;
    }

    private static int nextUnconsumed(Match[] matches, int startIndex) {
        int index;
        for (index = startIndex; index < matches.length && matches[index].consumed; ++index) {
        }
        return index;
    }

    private int indexOf(Object element, Object[] array, Match[] matches) {
        for (int i = 0; i < array.length; ++i) {
            if (matches[i] != null || !this.model.equal(element, array[i])) continue;
            return i;
        }
        return -1;
    }

    private int indexOfSimilar(Object element, Object[] candidates, Match[] matches) {
        for (int i = 0; i < candidates.length; ++i) {
            if (matches[i] != null || !this.model.correspond(element, candidates[i])) continue;
            return i;
        }
        return -1;
    }

    private String locator1(Object[] array, int index) {
        return this.parentLocator1 + this.model.subPath(array, index);
    }

    private String locator2(Object[] array, int index) {
        return this.parentLocator2 + this.model.subPath(array, index);
    }

    static class Match {
        public int i1;
        public int i2;
        public int type;
        public boolean consumed;

        public Match(int i1, int i2, int type) {
            this.i1 = i1;
            this.i2 = i2;
            this.type = type;
            this.consumed = false;
        }

        void consume() {
            this.consumed = true;
        }

        public String toString() {
            return this.type + " " + (this.i1 >= 0 ? String.valueOf(this.i1) : "") + " " + (this.i2 >= 0 ? String.valueOf(this.i2) : "");
        }
    }
}

