/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.compare;

import java.util.HashSet;
import java.util.Set;
import org.databene.formats.compare.ComparisonModel;
import org.databene.formats.compare.DiffDetailType;
import org.databene.formats.compare.LocalDiffType;

public class ComparisonSettings {
    protected ComparisonModel model;
    private Set<LocalDiffType> toleratedDiffs;

    public ComparisonSettings(ComparisonModel model) {
        this.model = model;
        this.toleratedDiffs = new HashSet<LocalDiffType>();
    }

    public ComparisonModel getModel() {
        return this.model;
    }

    public void addKeyExpression(String locator, String expression) {
        this.model.addKeyExpression(locator, expression);
    }

    public Set<LocalDiffType> getToleratedDiffs() {
        return this.toleratedDiffs;
    }

    public void addToleratedDiff(LocalDiffType toleratedDiff) {
        this.toleratedDiffs.add(toleratedDiff);
    }

    public void tolerateDifferentAt(String xPath) {
        this.toleratedDiffs.add(new LocalDiffType(DiffDetailType.DIFFERENT, xPath));
    }

    public void tolerateMissingAt(String xPath) {
        this.toleratedDiffs.add(new LocalDiffType(DiffDetailType.MISSING, xPath));
    }

    public void tolerateUnexpectedAt(String xPath) {
        this.toleratedDiffs.add(new LocalDiffType(DiffDetailType.UNEXPECTED, xPath));
    }

    public void tolerateMovedAt(String xPath) {
        this.toleratedDiffs.add(new LocalDiffType(DiffDetailType.MOVED, xPath));
    }

    public void tolerateAnyDiffAt(String xPath) {
        this.toleratedDiffs.add(new LocalDiffType(null, xPath));
    }

    public void tolerateGenericDiff(DiffDetailType type, String xPath) {
        this.toleratedDiffs.add(new LocalDiffType(type, xPath));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[model=" + this.model + ", toleratedDiffs=" + this.toleratedDiffs + "]";
    }
}

