/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.compare;

import org.databene.commons.Converter;
import org.databene.commons.NullSafeComparator;
import org.databene.formats.compare.DiffDetailType;

public class DiffDetail {
    protected final Object expected;
    protected final Object actual;
    protected final String objectClassifier;
    protected final DiffDetailType type;
    protected final String locatorOfExpected;
    protected final String locatorOfActual;
    protected final Converter<Object, String> formatter;

    public DiffDetail(Object expected, Object actual, String objectClassifier, DiffDetailType type, Converter<Object, String> formatter) {
        this(expected, actual, objectClassifier, type, null, null, formatter);
    }

    public DiffDetail(Object expected, Object actual, String objectClassifier, DiffDetailType type, String locatorOfExpected, String locatorOfActual, Converter<Object, String> formatter) {
        this.expected = expected;
        this.actual = actual;
        this.objectClassifier = objectClassifier;
        this.type = type;
        this.locatorOfExpected = locatorOfExpected;
        this.locatorOfActual = locatorOfActual;
        this.formatter = formatter;
    }

    public Object getExpected() {
        return this.expected;
    }

    public Object getActual() {
        return this.actual;
    }

    public String getObjectClassifier() {
        return this.objectClassifier;
    }

    public DiffDetailType getType() {
        return this.type;
    }

    public String getLocatorOfExpected() {
        return this.locatorOfExpected;
    }

    public String getLocatorOfActual() {
        return this.locatorOfActual;
    }

    public Converter<Object, String> getFormatter() {
        return this.formatter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.locatorOfExpected == null ? 0 : this.locatorOfExpected.hashCode());
        result = 31 * result + (this.locatorOfActual == null ? 0 : this.locatorOfActual.hashCode());
        result = 31 * result + (this.objectClassifier == null ? 0 : this.objectClassifier.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.expected == null ? 0 : this.expected.hashCode());
        result = 31 * result + (this.actual == null ? 0 : this.actual.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiffDetail that = (DiffDetail)obj;
        return NullSafeComparator.equals((Object)this.expected, (Object)that.expected) && NullSafeComparator.equals((Object)this.actual, (Object)that.actual) && NullSafeComparator.equals((Object)((Object)this.type), (Object)((Object)that.type)) && NullSafeComparator.equals((Object)this.locatorOfExpected, (Object)that.locatorOfExpected) && NullSafeComparator.equals((Object)this.locatorOfActual, (Object)that.locatorOfActual);
    }

    public String toString() {
        switch (this.type) {
            case DIFFERENT: {
                return this.formatDifferent();
            }
            case MISSING: {
                return this.formatMissing();
            }
            case UNEXPECTED: {
                return this.formatUnexpected();
            }
            case MOVED: {
                return this.formatMoved();
            }
        }
        return this.formatGenericDiff();
    }

    private String formatDifferent() {
        if (NullSafeComparator.equals((Object)this.locatorOfExpected, (Object)this.locatorOfActual)) {
            return "Different " + this.objectClassifier + ": expected " + this.formatObject(this.expected) + " but found " + this.formatObject(this.actual) + (this.locatorOfActual != null ? " at " + this.locatorOfActual : "");
        }
        return "Different " + this.objectClassifier + ": expected " + this.formatObject(this.expected) + (this.locatorOfExpected != null ? " at " + this.locatorOfExpected : "") + " but found " + this.formatObject(this.actual) + (this.locatorOfActual != null ? " at " + this.locatorOfActual : "");
    }

    private String formatMissing() {
        return "Missing " + this.objectClassifier + " " + this.formatObject(this.expected) + " at " + this.locatorOfExpected;
    }

    private String formatUnexpected() {
        return "Unexpected " + this.objectClassifier + " " + this.formatObject(this.actual) + " found at " + this.locatorOfActual;
    }

    private String formatMoved() {
        return "Moved " + this.objectClassifier + " " + this.formatObject(this.expected) + " from " + this.locatorOfExpected + " to " + this.locatorOfActual;
    }

    private String formatGenericDiff() {
        return (Object)((Object)this.type) + " " + this.objectClassifier + ", expected " + this.formatObject(this.expected) + ", found " + this.actual + " " + this.locatorOfExpected + " " + this.locatorOfActual;
    }

    private String formatObject(Object value) {
        return (String)this.formatter.convert(value);
    }
}

