/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.compare;

import org.databene.commons.ConfigurationError;
import org.databene.commons.NullSafeComparator;
import org.databene.commons.StringUtil;
import org.databene.formats.compare.DiffDetailType;

public class LocalDiffType {
    private final String locator;
    private final DiffDetailType type;

    public LocalDiffType(DiffDetailType type, String locator) {
        if (StringUtil.isEmpty((CharSequence)locator) && type == null) {
            throw new ConfigurationError("At least one of the argument 'locator' and 'type' must be not empty");
        }
        this.locator = locator;
        this.type = type;
    }

    public String getLocator() {
        return this.locator;
    }

    public DiffDetailType getType() {
        return this.type;
    }

    public int hashCode() {
        int result = this.type == null ? 1 : this.type.hashCode();
        return 31 * result + (this.locator == null ? 0 : this.locator.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocalDiffType that = (LocalDiffType)obj;
        return NullSafeComparator.equals((Object)((Object)this.type), (Object)((Object)that.type)) && NullSafeComparator.equals((Object)this.locator, (Object)that.locator);
    }

    public String toString() {
        return (this.type != null ? this.type.toString() : "Any diff") + " for " + (this.locator != null ? " XPath " + this.locator : "any location");
    }
}

