/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.csv;

import java.io.IOException;
import org.databene.formats.DataIterator;
import org.databene.formats.csv.CSVCellIterator;
import org.databene.formats.csv.CSVLineIterator;
import org.databene.formats.csv.CSVSingleColumIterator;

public class CSVIteratorFactory {
    private CSVIteratorFactory() {
    }

    public static DataIterator<String> createCSVCellIterator(String uri, char separator, String encoding) throws IOException {
        return new CSVCellIterator(uri, separator, encoding);
    }

    public static DataIterator<String> createCSVVellIteratorForColumn(String uri, int column, char separator, boolean ignoreEmptyLines, String encoding) throws IOException {
        return new CSVSingleColumIterator(uri, column, separator, ignoreEmptyLines, encoding);
    }

    public static DataIterator<String[]> createCSVLineIterator(String uri, char separator, boolean ignoreEmptyLines, String encoding) throws IOException {
        return new CSVLineIterator(uri, separator, ignoreEmptyLines, encoding);
    }
}

