/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.csv;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import org.databene.commons.CollectionUtil;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;
import org.databene.formats.DataContainer;
import org.databene.formats.DataIterator;
import org.databene.formats.csv.CSVLineHandler;
import org.databene.formats.csv.CSVTokenType;
import org.databene.formats.csv.CSVTokenizer;

public class CSVLineIterator
implements DataIterator<String[]> {
    public static final char DEFAULT_SEPARATOR = ',';
    private String stringRep;
    private CSVTokenizer tokenizer;
    private String[] nextLine;
    private boolean ignoreEmptyLines;
    private int lineCount;
    private String[] headers;
    private HashMap<String, Integer> headerIndexes;

    public CSVLineIterator(String uri) throws IOException {
        this(uri, ',');
    }

    public CSVLineIterator(String uri, char separator) throws IOException {
        this(uri, separator, false);
    }

    public CSVLineIterator(String uri, char separator, String encoding) throws IOException {
        this(uri, separator, false, encoding);
    }

    public CSVLineIterator(String uri, char separator, boolean ignoreEmptyLines) throws IOException {
        this(uri, separator, ignoreEmptyLines, SystemInfo.getFileEncoding());
    }

    public CSVLineIterator(String uri, char separator, boolean ignoreEmptyLines, String encoding) throws IOException {
        this(IOUtil.getReaderForURI((String)uri, (String)encoding), separator, ignoreEmptyLines);
        this.stringRep = uri;
    }

    public CSVLineIterator(Reader reader, char separator) throws IOException {
        this(reader, separator, false);
    }

    public CSVLineIterator(Reader reader, char separator, boolean ignoreEmptyLines) throws IOException {
        this.tokenizer = new CSVTokenizer(reader, separator);
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.nextLine = this.parseNextLine();
        this.lineCount = 0;
        this.stringRep = reader.toString();
    }

    public void setHeaders(String[] headers) {
        this.headers = headers != null ? headers : new String[0];
        this.headerIndexes = new HashMap();
        for (int i = 0; i < this.headers.length; ++i) {
            this.headerIndexes.put(this.headers[i], i);
        }
    }

    @Override
    public Class<String[]> getType() {
        return String[].class;
    }

    @Override
    public synchronized DataContainer<String[]> next(DataContainer<String[]> wrapper) {
        if (this.nextLine == null) {
            return null;
        }
        try {
            String[] result = this.nextLine;
            if (this.tokenizer != null) {
                this.nextLine = this.parseNextLine();
                ++this.lineCount;
            } else {
                this.nextLine = null;
            }
            return wrapper.setData(result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] cellsByHeaders(String[] headers, String[] data) {
        String[] result = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            result[i] = this.cellByHeader(headers[i], data);
        }
        return result;
    }

    public String cellByHeader(String header, String[] data) {
        Integer index = this.headerIndexes.get(header);
        return index != null && index < data.length ? data[index] : null;
    }

    public int columnIndexOfHeader(String header) {
        return this.headerIndexes.get(header);
    }

    @Override
    public synchronized void close() {
        if (this.tokenizer != null) {
            this.tokenizer.close();
        }
        this.tokenizer = null;
        this.nextLine = null;
    }

    public synchronized int lineCount() {
        return this.lineCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(String uri, char separator, String encoding, boolean ignoreEmptyLines, CSVLineHandler lineHandler) throws IOException {
        CSVLineIterator iterator = null;
        try {
            iterator = new CSVLineIterator(uri, separator, ignoreEmptyLines, encoding);
            DataContainer<String[]> row = new DataContainer<String[]>();
            while ((row = iterator.next(row)) != null) {
                lineHandler.handle(row.getData());
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    private String[] parseNextLine() throws IOException {
        ArrayList<String> list;
        CSVTokenType tokenType;
        if (this.tokenizer == null) {
            return null;
        }
        do {
            list = new ArrayList<String>();
            while ((tokenType = this.tokenizer.next()) == CSVTokenType.CELL) {
                list.add(this.tokenizer.cell);
            }
        } while (tokenType != CSVTokenType.EOF && this.ignoreEmptyLines && list.size() == 0);
        if (tokenType == CSVTokenType.EOF) {
            this.close();
        }
        if (list.size() > 0) {
            String[] line = (String[])CollectionUtil.toArray(list, String.class);
            this.checkHeaders(line);
            return line;
        }
        if (tokenType != CSVTokenType.EOF) {
            String[] line = new String[]{};
            this.checkHeaders(line);
            if (!this.ignoreEmptyLines) {
                return line;
            }
        }
        return null;
    }

    private void checkHeaders(String[] line) {
        if (this.headers == null) {
            this.setHeaders(line);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.stringRep + "]";
    }
}

