/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.csv;

import java.io.IOException;
import org.databene.commons.StringUtil;
import org.databene.formats.DataContainer;
import org.databene.formats.csv.CSVLineIterator;
import org.databene.formats.util.DataIteratorAdapter;
import org.databene.formats.util.ThreadLocalDataContainer;

public class CSVSingleColumIterator
extends DataIteratorAdapter<String[], String> {
    private static final char DEFAULT_SEPARATOR = ',';
    private int columnIndex;
    ThreadLocalDataContainer<String[]> rowContainer = new ThreadLocalDataContainer();

    public CSVSingleColumIterator(String uri, int columnIndex) throws IOException {
        this(uri, columnIndex, ',', false, "UTF-8");
    }

    public CSVSingleColumIterator(String uri, int columnIndex, char separator, boolean ignoreEmptyLines, String encoding) throws IOException {
        super(new CSVLineIterator(uri, separator, ignoreEmptyLines, encoding));
        if (StringUtil.isEmpty((CharSequence)uri)) {
            throw new IllegalArgumentException("URI is empty");
        }
        if (columnIndex < 0) {
            throw new IllegalArgumentException("Negative column index: " + columnIndex);
        }
        this.columnIndex = columnIndex;
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public DataContainer<String> next(DataContainer<String> wrapper) {
        DataContainer tmp = this.source.next((DataContainer)this.rowContainer.get());
        if (tmp == null) {
            return null;
        }
        String[] nextRow = (String[])tmp.getData();
        return wrapper.setData(this.columnIndex < nextRow.length ? nextRow[this.columnIndex] : null);
    }
}

