/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.mutator.AnyMutator;
import org.databene.commons.mutator.NamedMutator;
import org.databene.formats.DataContainer;
import org.databene.formats.DataIterator;
import org.databene.formats.csv.CSVLineIterator;
import org.databene.formats.util.ThreadLocalDataContainer;

public class CSVToJavaBeanMapper<E>
implements DataIterator<E> {
    private CSVLineIterator iterator;
    private Class<E> type;
    private String emptyValue;
    private NamedMutator[] mutators;
    private int classIndex;
    private ThreadLocalDataContainer<String[]> dataContainer = new ThreadLocalDataContainer();

    public CSVToJavaBeanMapper(Reader reader, Class<E> type) throws IOException {
        this(reader, type, ',', null);
    }

    public CSVToJavaBeanMapper(Reader reader, Class<E> type, char separator, String emptyValue) throws IOException {
        CSVLineIterator iterator = new CSVLineIterator(reader, separator, true);
        DataContainer<String[]> tmp = iterator.next((DataContainer)this.dataContainer.get());
        if (tmp != null) {
            String[] attributeNames = tmp.getData();
            this.init(iterator, type, emptyValue, attributeNames);
        }
    }

    public CSVToJavaBeanMapper(Reader reader, Class<E> type, char separator, String emptyValue, String[] attributeNames) throws IOException {
        CSVLineIterator iterator = new CSVLineIterator(reader, separator, true);
        this.init(iterator, type, emptyValue, attributeNames);
    }

    @Override
    public Class<E> getType() {
        return this.type;
    }

    @Override
    public DataContainer<E> next(DataContainer<E> wrapper) {
        int i = 0;
        String value = null;
        try {
            DataContainer<String[]> tmp = this.nextRaw((DataContainer)this.dataContainer.get());
            if (tmp == null) {
                return null;
            }
            String[] line = tmp.getData();
            if (line.length == 0) {
                return null;
            }
            Class beanClass = this.classIndex >= 0 ? BeanUtil.forName((String)line[this.classIndex]) : this.type;
            Object bean = BeanUtil.newInstance((Class)beanClass);
            int columns = Math.min(line.length, this.mutators.length);
            for (i = 0; i < columns; ++i) {
                if (i == this.classIndex) continue;
                value = line[i];
                if (value != null && value.length() == 0) {
                    value = this.emptyValue;
                }
                this.mutators[i].setValue(bean, (Object)value);
            }
            return wrapper.setData(bean);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationError("Failed to set property '" + this.mutators[i].getName() + "' to '" + value + "' on class " + this.type, (Throwable)e);
        }
    }

    public DataContainer<String[]> nextRaw(DataContainer<String[]> wrapper) {
        return this.iterator.next(wrapper);
    }

    @Override
    public void close() {
        IOUtil.close((Closeable)this.iterator);
    }

    public void skip() {
        this.iterator.next((DataContainer)this.dataContainer.get());
    }

    private void init(CSVLineIterator iterator, Class<E> type, String emptyValue, String[] attributeNames) {
        this.iterator = iterator;
        this.type = type;
        this.emptyValue = emptyValue;
        this.mutators = new NamedMutator[attributeNames.length];
        this.classIndex = -1;
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            if ("class".equals(attributeName)) {
                this.mutators[i] = null;
                this.classIndex = i;
                continue;
            }
            this.mutators[i] = new AnyMutator(attributeName, false, true);
        }
    }
}

