/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.csv;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;
import org.databene.formats.csv.CSVTokenType;

public class CSVTokenizer
implements Closeable {
    public static final char DEFAULT_SEPARATOR = ',';
    private static final char DEFAULT_LINE_COMMENT = '#';
    private PushbackReader reader;
    private char separator;
    public CSVTokenType ttype;
    public CSVTokenType lastType;
    public String cell;
    public int line;

    public CSVTokenizer(String uri) throws IOException {
        this(uri, ',');
    }

    public CSVTokenizer(String uri, char separator) throws IOException {
        this(uri, separator, SystemInfo.getFileEncoding());
    }

    public CSVTokenizer(String uri, char separator, String encoding) throws IOException {
        this(IOUtil.getReaderForURI((String)uri, (String)encoding), separator);
    }

    public CSVTokenizer(Reader reader) {
        this(reader, ',');
    }

    public CSVTokenizer(Reader reader, char separator) {
        this.reader = new PushbackReader(new BufferedReader(reader));
        this.separator = separator;
        this.line = 1;
    }

    public CSVTokenType next() throws IOException {
        int c;
        this.lastType = this.ttype;
        if (this.reader == null) {
            return this.setState(CSVTokenType.EOF, null);
        }
        if (this.lastType == CSVTokenType.EOL) {
            ++this.line;
        }
        if ((c = this.read()) == -1) {
            this.close();
            return this.setState(CSVTokenType.EOF, null);
        }
        if (this.lastType == CSVTokenType.EOL && c == 35) {
            this.skipLine();
            return this.next();
        }
        if (c == this.separator && this.lastType == CSVTokenType.CELL) {
            c = this.read();
        }
        if (c == -1) {
            this.close();
            return this.setState(CSVTokenType.CELL, null);
        }
        if (c == this.separator) {
            this.unread(c);
            return this.setState(CSVTokenType.CELL, null);
        }
        if (c == 13) {
            c = this.read();
            if (c != 10) {
                this.unread(c);
            }
            return this.setState(CSVTokenType.EOL, null);
        }
        if (c == 10) {
            return this.setState(CSVTokenType.EOL, null);
        }
        if (c == 34) {
            this.unread(c);
            return this.parseQuotes();
        }
        return this.parseSimpleCell(c);
    }

    public void skipLine() throws IOException {
        int c;
        while ((c = this.read()) != -1 && c != 13 && c != 10) {
        }
        switch (c) {
            case -1: {
                return;
            }
            case 10: {
                return;
            }
            case 13: {
                int c2 = this.read();
                if (c2 != 10) {
                    this.unread(c2);
                }
                return;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void close() {
        if (this.reader != null) {
            IOUtil.close((Closeable)this.reader);
        }
        this.reader = null;
    }

    public CSVTokenType lastTtype() {
        return this.lastType;
    }

    private CSVTokenType setState(CSVTokenType tokenType, String cell) {
        this.cell = cell;
        this.ttype = tokenType;
        return this.ttype;
    }

    private void unread(int c) throws IOException {
        this.reader.unread(c);
    }

    private int read() throws IOException {
        int c = this.reader.read();
        return c;
    }

    private CSVTokenType parseSimpleCell(int c) throws IOException {
        StringBuilder buffer = new StringBuilder().append((char)c);
        boolean escapeMode = false;
        while ((c = this.read()) != -1 && c != 13 && c != 10) {
            if (escapeMode) {
                c = CSVTokenizer.unescape((char)c);
                escapeMode = false;
            } else if (c == 92) {
                escapeMode = true;
                continue;
            }
            if (c == this.separator) {
                this.unread(c);
                return this.setState(CSVTokenType.CELL, buffer.toString());
            }
            buffer.append((char)c);
        }
        if (c == 13 || c == 10 || c == this.separator) {
            this.unread(c);
        }
        return this.setState(CSVTokenType.CELL, buffer.toString());
    }

    private static char unescape(char c) {
        switch (c) {
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
        }
        return c;
    }

    private CSVTokenType parseQuotes() throws IOException {
        int c;
        this.read();
        StringBuilder buffer = new StringBuilder();
        boolean escapeMode = false;
        while (true) {
            boolean done;
            if ((c = this.read()) != -1 && c != 34) {
                if (escapeMode) {
                    c = CSVTokenizer.unescape((char)c);
                    escapeMode = false;
                } else if (c == 92) {
                    escapeMode = true;
                    continue;
                }
                buffer.append((char)c);
                continue;
            }
            if (c == 34) {
                c = this.read();
                if (c == 34) {
                    buffer.append('\"');
                    done = false;
                } else {
                    done = true;
                }
            } else {
                done = true;
            }
            if (done) break;
        }
        if (c == 13 || c == 10 || c == this.separator) {
            this.unread(c);
        }
        return this.setState(CSVTokenType.CELL, buffer.toString());
    }
}

