/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ConfigurationError;
import org.databene.commons.IOUtil;
import org.databene.commons.SystemInfo;
import org.databene.formats.DataContainer;
import org.databene.formats.csv.CSVLineIterator;
import org.databene.formats.csv.CSVTokenType;
import org.databene.formats.csv.CSVTokenizer;

public class CSVUtil {
    public static String[] parseHeader(String uri, char separator, String encoding) {
        CSVLineIterator cellIterator;
        block5: {
            cellIterator = null;
            cellIterator = new CSVLineIterator(uri, separator, true, encoding);
            DataContainer tmp = cellIterator.next(new DataContainer());
            if (tmp == null) break block5;
            String[] stringArray = (String[])tmp.getData();
            IOUtil.close((Closeable)cellIterator);
            return stringArray;
        }
        try {
            try {
                throw new ConfigurationError("empty CSV file");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(cellIterator);
            throw throwable;
        }
    }

    public static String[][] parseRows(String url, char separator) throws IOException {
        return CSVUtil.parseRows(url, separator, SystemInfo.getFileEncoding());
    }

    public static String[][] parseRows(String url, char separator, String encoding) throws IOException {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        CSVLineIterator iterator = new CSVLineIterator(url, separator, encoding);
        DataContainer<String[]> container = new DataContainer<String[]>();
        while ((container = iterator.next(container)) != null) {
            lines.add(container.getData());
        }
        iterator.close();
        String[][] result = new String[lines.size()][];
        return (String[][])lines.toArray((T[])result);
    }

    public static String[] parseCSVRow(String text) {
        ArrayBuilder builder = new ArrayBuilder(String.class);
        CSVTokenizer tokenizer = new CSVTokenizer(new StringReader(text));
        try {
            CSVTokenType type;
            while ((type = tokenizer.next()) != CSVTokenType.EOL && type != CSVTokenType.EOF) {
                builder.add((Object)tokenizer.cell);
            }
            String[] stringArray = (String[])builder.toArray();
            return stringArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing CSV row: " + text, e);
        }
        finally {
            IOUtil.close((Closeable)tokenizer);
        }
    }

    public static void writeRow(Writer out, char separator, String ... cells) throws IOException {
        if (cells.length > 0) {
            out.write(CSVUtil.renderCell(cells[0], separator));
        }
        for (int i = 1; i < cells.length; ++i) {
            out.write(separator);
            out.write(CSVUtil.renderCell(cells[i], separator));
        }
        out.write(SystemInfo.getLineSeparator());
    }

    public static String renderCell(String text, char separator) {
        if (text == null) {
            return "";
        }
        if (text.indexOf(separator) < 0 && text.indexOf(34) < 0) {
            return text;
        }
        text = text.replace("\"", "\"\"");
        return '\"' + text + '\"';
    }

    public static String formatHeaderWithLineFeed(char separator, String ... propertyNames) {
        return ArrayFormat.format((String)String.valueOf(separator), (Object[])propertyNames) + SystemInfo.getLineSeparator();
    }
}

