/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.databene.commons.Converter;
import org.databene.formats.DataContainer;
import org.databene.formats.DataIterator;
import org.databene.formats.csv.CSVLineIterator;
import org.databene.formats.util.ThreadLocalDataContainer;

public class ConvertingCSVParser<E>
implements DataIterator<E> {
    private Converter<String[], E> rowConverter;
    private CSVLineIterator source;
    private ThreadLocalDataContainer<String[]> dataContainer = new ThreadLocalDataContainer();

    public ConvertingCSVParser(String uri, Converter<String[], E> rowConverter) throws IOException {
        this.source = new CSVLineIterator(uri);
        this.rowConverter = rowConverter;
    }

    @Override
    public Class<E> getType() {
        return this.rowConverter.getTargetType();
    }

    @Override
    public DataContainer<E> next(DataContainer<E> wrapper) {
        DataContainer<String[]> tmp = this.source.next((DataContainer)this.dataContainer.get());
        if (tmp == null) {
            return null;
        }
        return wrapper.setData(this.rowConverter.convert((Object)tmp.getData()));
    }

    @Override
    public void close() {
        this.source.close();
    }

    public static <T> List<T> parse(String uri, Converter<String[], T> rowConverter) throws IOException {
        return ConvertingCSVParser.parse(uri, rowConverter, new ArrayList());
    }

    public static <T> List<T> parse(String uri, Converter<String[], T> rowConverter, List<T> list) throws IOException {
        ConvertingCSVParser<T> parser = new ConvertingCSVParser<T>(uri, rowConverter);
        DataContainer<Object> container = new DataContainer();
        while ((container = parser.next(container)) != null) {
            list.add(container.getData());
        }
        return list;
    }
}

