/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.dot;

import java.util.Collection;
import org.databene.formats.dot.ArrowShape;
import org.databene.formats.dot.DotGraphModel;
import org.databene.formats.dot.DotUtil;
import org.databene.formats.dot.EdgeStyle;
import org.databene.formats.dot.NodeShape;
import org.databene.formats.dot.NodeStyle;
import org.databene.formats.dot.RankDir;

public abstract class AbstractDotGraphModel
implements DotGraphModel {
    private String name = null;
    private boolean directed = true;
    private RankDir rankDir = null;
    private NodeShape nodeShape = null;
    private Integer nodeFontSize = null;
    private NodeStyle nodeStyle = null;
    private String nodeFillColor = null;
    private ArrowShape arrowHead = null;
    private ArrowShape arrowTail = null;
    private EdgeStyle edgeStyle = null;

    @Override
    public String getName() {
        return this.name;
    }

    public AbstractDotGraphModel setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    public AbstractDotGraphModel withDirected() {
        this.directed = true;
        return this;
    }

    public AbstractDotGraphModel withUndirected() {
        this.directed = false;
        return this;
    }

    @Override
    public RankDir getRankDir() {
        return this.rankDir;
    }

    public AbstractDotGraphModel withRankDir(RankDir rankDir) {
        this.rankDir = rankDir;
        return this;
    }

    @Override
    public NodeShape getNodeShape() {
        return this.nodeShape;
    }

    public AbstractDotGraphModel withNodeShape(NodeShape nodeShape) {
        this.nodeShape = nodeShape;
        return this;
    }

    @Override
    public Integer getNodeFontSize() {
        return this.nodeFontSize;
    }

    public AbstractDotGraphModel withNodeFontSize(int fontSize) {
        this.nodeFontSize = fontSize;
        return this;
    }

    @Override
    public NodeStyle getNodeStyle() {
        return this.nodeStyle;
    }

    public AbstractDotGraphModel withNodeStyle(NodeStyle nodeStyle) {
        this.nodeStyle = nodeStyle;
        return this;
    }

    @Override
    public String getNodeFillColor() {
        return this.nodeFillColor;
    }

    public AbstractDotGraphModel withNodeFillColor(String color) {
        this.nodeFillColor = color;
        return this;
    }

    @Override
    public ArrowShape getEdgeArrowHead() {
        return this.arrowHead;
    }

    public AbstractDotGraphModel withEdgeArrowHead(ArrowShape arrowHead) {
        this.arrowHead = arrowHead;
        return this;
    }

    @Override
    public ArrowShape getEdgeArrowTail() {
        return this.arrowTail;
    }

    public AbstractDotGraphModel withEdgeArrowTail(ArrowShape arrowTail) {
        this.arrowTail = arrowTail;
        return this;
    }

    @Override
    public EdgeStyle getEdgeStyle() {
        return this.edgeStyle;
    }

    public AbstractDotGraphModel withEdgeStyle(EdgeStyle edgeStyle) {
        this.edgeStyle = edgeStyle;
        return this;
    }

    @Override
    public boolean isNodeVertical(Object node) {
        return true;
    }

    @Override
    public String getNodeLabel(Object node) {
        return DotUtil.segmentsToLabel(this.getNodeSegments(node), this.isNodeVertical(node));
    }

    @Override
    public Collection<?> getNodeSegments(Object node) {
        return null;
    }

    @Override
    public NodeStyle getNodeStyle(Object node) {
        return null;
    }

    @Override
    public String getNodeFillColor(Object node) {
        return null;
    }

    @Override
    public ArrowShape getEdgeArrowHead(Object edge) {
        return null;
    }

    @Override
    public String getEdgeHeadLabel(Object edge) {
        return null;
    }

    @Override
    public ArrowShape getEdgeArrowTail(Object edge) {
        return null;
    }

    @Override
    public String getEdgeTailLabel(Object edge) {
        return null;
    }

    @Override
    public EdgeStyle getEdgeStyle(Object edge) {
        return null;
    }
}

