/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.dot;

import java.util.Collection;
import org.databene.formats.dot.ArrowShape;
import org.databene.formats.dot.DotEdge;
import org.databene.formats.dot.DotGraph;
import org.databene.formats.dot.DotGraphModel;
import org.databene.formats.dot.DotNode;
import org.databene.formats.dot.DotUtil;
import org.databene.formats.dot.EdgeStyle;
import org.databene.formats.dot.NodeShape;
import org.databene.formats.dot.NodeStyle;
import org.databene.formats.dot.RankDir;

public class DefaultDotGraphModel
implements DotGraphModel {
    private DotGraph graph;

    public DefaultDotGraphModel(DotGraph graph) {
        this.graph = graph;
    }

    @Override
    public String getName() {
        return this.graph.getName();
    }

    @Override
    public boolean isDirected() {
        return this.graph.isDirected();
    }

    @Override
    public RankDir getRankDir() {
        return this.graph.getRankDir();
    }

    @Override
    public NodeShape getNodeShape() {
        return this.graph.getNodeShape();
    }

    @Override
    public Integer getNodeFontSize() {
        return this.graph.getNodeFontSize();
    }

    @Override
    public NodeStyle getNodeStyle() {
        return this.graph.getNodeStyle();
    }

    @Override
    public String getNodeFillColor() {
        return this.graph.getNodeFillColor();
    }

    @Override
    public ArrowShape getEdgeArrowHead() {
        return this.graph.getEdgeArrowHead();
    }

    @Override
    public ArrowShape getEdgeArrowTail() {
        return this.graph.getEdgeArrowTail();
    }

    @Override
    public EdgeStyle getEdgeStyle() {
        return this.graph.getEdgeStyle();
    }

    @Override
    public int getNodeCount() {
        return this.graph.getNodes().size();
    }

    @Override
    public Object getNode(int index) {
        return this.graph.getNodes().get(index);
    }

    @Override
    public String getNodeId(Object node) {
        return ((DotNode)node).getName();
    }

    @Override
    public boolean isNodeVertical(Object node) {
        return ((DotNode)node).isVertical();
    }

    @Override
    public String getNodeLabel(Object node) {
        return DotUtil.segmentsToLabel(this.getNodeSegments(node), this.isNodeVertical(node));
    }

    @Override
    public Collection<?> getNodeSegments(Object node) {
        return ((DotNode)node).getSegments();
    }

    @Override
    public String getNodeFillColor(Object node) {
        return ((DotNode)node).getFillColor();
    }

    @Override
    public NodeStyle getNodeStyle(Object node) {
        return ((DotNode)node).getStyle();
    }

    @Override
    public int getEdgeCountOfNode(Object node) {
        return ((DotNode)node).getEdges().size();
    }

    @Override
    public Object getEdgeOfNode(Object node, int index) {
        return ((DotNode)node).getEdges().get(index);
    }

    @Override
    public Object getTargetNodeOfEdge(Object sourceNode, Object edge) {
        return ((DotEdge)edge).getTo();
    }

    @Override
    public ArrowShape getEdgeArrowHead(Object edge) {
        return ((DotEdge)edge).getArrowHead();
    }

    @Override
    public String getEdgeHeadLabel(Object edge) {
        return ((DotEdge)edge).getHeadLabel();
    }

    @Override
    public ArrowShape getEdgeArrowTail(Object edge) {
        return ((DotEdge)edge).getArrowTail();
    }

    @Override
    public String getEdgeTailLabel(Object edge) {
        return ((DotEdge)edge).getTailLabel();
    }

    @Override
    public EdgeStyle getEdgeStyle(Object edge) {
        return ((DotEdge)edge).getStyle();
    }
}

