/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.dot;

import java.util.List;
import org.databene.commons.Named;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.formats.dot.ArrowShape;
import org.databene.formats.dot.DotNode;
import org.databene.formats.dot.EdgeStyle;
import org.databene.formats.dot.NodeShape;
import org.databene.formats.dot.NodeStyle;
import org.databene.formats.dot.RankDir;

public class DotGraph
implements Named {
    private String name;
    private final boolean directed;
    private RankDir rankDir;
    private NodeShape nodeShape;
    private Integer nodeFontSize;
    private NodeStyle nodeStyle;
    private String nodeFillColor;
    private EdgeStyle edgeStyle;
    private ArrowShape edgeArrowHead;
    private ArrowShape edgeArrowTail;
    private OrderedNameMap<DotNode> nodes;

    private DotGraph(String name, boolean directed) {
        this.name = name;
        this.directed = directed;
        this.rankDir = null;
        this.nodeShape = null;
        this.nodeFontSize = null;
        this.nodeStyle = null;
        this.nodeFillColor = null;
        this.edgeStyle = null;
        this.edgeArrowHead = null;
        this.edgeArrowTail = null;
        this.nodes = new OrderedNameMap();
    }

    public static DotGraph newDirectedGraph(String name) {
        return new DotGraph(name, true);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public RankDir getRankDir() {
        return this.rankDir;
    }

    public DotGraph withRankDir(RankDir rankDir) {
        this.rankDir = rankDir;
        return this;
    }

    public NodeShape getNodeShape() {
        return this.nodeShape;
    }

    public DotGraph withNodeShape(NodeShape shape) {
        this.nodeShape = shape;
        return this;
    }

    public Integer getNodeFontSize() {
        return this.nodeFontSize;
    }

    public DotGraph withNodeFontSize(int points) {
        this.nodeFontSize = points;
        return this;
    }

    public NodeStyle getNodeStyle() {
        return this.nodeStyle;
    }

    public DotGraph withNodeStyle(NodeStyle style) {
        this.nodeStyle = style;
        return this;
    }

    public String getNodeFillColor() {
        return this.nodeFillColor;
    }

    public DotGraph withNodeFillColor(String fillColor) {
        this.nodeFillColor = fillColor;
        return this;
    }

    public EdgeStyle getEdgeStyle() {
        return this.edgeStyle;
    }

    public DotGraph withEdgeStyle(EdgeStyle edgeStyle) {
        this.edgeStyle = edgeStyle;
        return this;
    }

    public ArrowShape getEdgeArrowHead() {
        return this.edgeArrowHead;
    }

    public DotGraph withArrowHead(ArrowShape arrowHead) {
        this.edgeArrowHead = arrowHead;
        return this;
    }

    public ArrowShape getEdgeArrowTail() {
        return this.edgeArrowTail;
    }

    public DotGraph withEdgeArrowTail(ArrowShape arrowTail) {
        this.edgeArrowTail = arrowTail;
        return this;
    }

    public DotNode newNode(String name) {
        DotNode node = new DotNode(name);
        this.nodes.put((Object)node.getName(), (Object)node);
        return node;
    }

    public List<DotNode> getNodes() {
        return this.nodes.values();
    }
}

