/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.dot;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.Named;
import org.databene.formats.dot.DotEdge;
import org.databene.formats.dot.NodeStyle;

public class DotNode
implements Named {
    private String name;
    private boolean vertical;
    private NodeStyle style;
    private String fillColor;
    private List<String> segments;
    private List<DotEdge> edges;

    public DotNode(String name) {
        this.name = name;
        this.vertical = true;
        this.style = null;
        this.fillColor = null;
        this.segments = new ArrayList<String>();
        this.edges = new ArrayList<DotEdge>();
    }

    public String getName() {
        return this.name;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public NodeStyle getStyle() {
        return this.style;
    }

    public DotNode withStyle(NodeStyle style) {
        this.style = style;
        return this;
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public DotEdge newEdgeTo(DotNode target) {
        DotEdge edge = new DotEdge(this, target);
        this.edges.add(edge);
        return edge;
    }

    public List<DotEdge> getEdges() {
        return this.edges;
    }

    public DotNode withEdgeTo(DotNode target) {
        this.newEdgeTo(target);
        return this;
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public DotNode withSegment(String ... lines) {
        StringBuilder segment = new StringBuilder();
        for (String line : lines) {
            segment.append(line).append("\\l");
        }
        this.segments.add(segment.toString());
        return this;
    }

    public String toString() {
        return this.getName();
    }
}

