/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.dot;

import java.util.Collection;
import org.databene.commons.StringUtil;

public class DotUtil {
    public static String normalizeId(String id) {
        if (id.startsWith("\"") && id.startsWith("\"")) {
            return id;
        }
        if (id.contains(" ") || id.contains("-")) {
            return '\"' + id + '\"';
        }
        return id;
    }

    public static String normalizeColor(String color) {
        if (StringUtil.isEmpty((CharSequence)color)) {
            return null;
        }
        String baseColor = color.startsWith("\"") && color.endsWith("\"") ? color.substring(1, color.length() - 1) : color;
        return baseColor.contains("#") ? '\"' + baseColor + '\"' : baseColor;
    }

    public static String segmentsToLabel(Collection<?> segments, boolean vertical) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        if (segments != null) {
            for (Object segment : segments) {
                if (!first) {
                    builder.append('|');
                }
                builder.append(segment);
                first = false;
            }
            if (builder.length() == 0) {
                return null;
            }
            if (!vertical) {
                builder.insert(0, "{").append("}");
            }
            return builder.toString();
        }
        return null;
    }

    public static String formatLines(String ... lines) {
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            DotUtil.addLine(line, builder);
        }
        return builder.toString();
    }

    public static void addLine(String line, StringBuilder builder) {
        builder.append(line).append("\\l");
    }
}

