/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.dot;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.databene.commons.IOUtil;
import org.databene.commons.StringUtil;
import org.databene.commons.collection.OrderedNameMap;
import org.databene.formats.dot.DotGraphModel;
import org.databene.formats.dot.DotUtil;

public class DotWriter {
    public static void persist(DotGraphModel model, OutputStream os) {
        DotWriter.persist(model, os, "UTF-8");
    }

    public static void persist(DotGraphModel model, OutputStream os, String encoding) {
        PrintWriter out = null;
        try {
            Object node;
            int i;
            out = new PrintWriter(new OutputStreamWriter(os, encoding));
            out.print(model.isDirected() ? "digraph" : "graph");
            if (!StringUtil.isEmpty((CharSequence)model.getName())) {
                out.print(" " + model.getName());
            }
            out.println(" {");
            new AttributesWriter("graph").add("charset", encoding).add("rankdir", (Object)model.getRankDir()).write(out);
            new AttributesWriter("node").add("shape", (Object)model.getNodeShape()).add("fontsize", model.getNodeFontSize()).add("style", (Object)model.getNodeStyle()).add("fillcolor", DotUtil.normalizeColor(model.getNodeFillColor())).write(out);
            new AttributesWriter("edge").add("arrowhead", (Object)model.getEdgeArrowHead()).add("arrowtail", (Object)model.getEdgeArrowTail()).add("style", (Object)model.getEdgeStyle()).write(out);
            for (i = 0; i < model.getNodeCount(); ++i) {
                node = model.getNode(i);
                DotWriter.writeNode(node, model, out);
            }
            for (i = 0; i < model.getNodeCount(); ++i) {
                node = model.getNode(i);
                DotWriter.writeEdges(node, model, out);
            }
            out.println("}");
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new UnsupportedOperationException("Not a supported encoding: " + encoding, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)out);
    }

    private static void writeNode(Object node, DotGraphModel model, PrintWriter out) {
        out.print("\t" + model.getNodeId(node));
        String label = model.getNodeLabel(node);
        if (label != null) {
            label = '\"' + label + '\"';
        }
        new AttributesWriter().add("label", label).add("fillcolor", DotUtil.normalizeColor(model.getNodeFillColor(node))).write(out);
    }

    private static void writeEdges(Object node, DotGraphModel model, PrintWriter out) {
        for (int i = 0; i < model.getEdgeCountOfNode(node); ++i) {
            Object edge = model.getEdgeOfNode(node, i);
            DotWriter.writeEdge(node, edge, model, out);
        }
    }

    private static void writeEdge(Object sourceNode, Object edge, DotGraphModel model, PrintWriter out) {
        Object target = model.getTargetNodeOfEdge(sourceNode, edge);
        out.print("\t" + model.getNodeId(sourceNode) + " " + (model.isDirected() ? "->" : "--") + " " + model.getNodeId(target));
        new AttributesWriter().add("arrowhead", (Object)model.getEdgeArrowHead(edge)).add("headlabel", model.getEdgeHeadLabel(edge)).add("arrowtail", (Object)model.getEdgeArrowTail(edge)).add("taillabel", model.getEdgeTailLabel(edge)).add("style", (Object)model.getEdgeStyle(edge)).write(out);
    }

    static class AttributesWriter {
        String label;
        OrderedNameMap<Object> map;

        public AttributesWriter() {
            this(null);
        }

        public AttributesWriter(String label) {
            this.label = label;
            this.map = new OrderedNameMap();
        }

        public AttributesWriter add(String name, Object value) {
            if (value != null) {
                this.map.put((Object)name, value);
            }
            return this;
        }

        public void write(PrintWriter out) {
            if (!this.map.isEmpty()) {
                if (this.label != null) {
                    out.print("\t" + this.label);
                }
                out.print(" [");
                boolean first = true;
                for (Map.Entry entry : this.map.entrySet()) {
                    if (!first) {
                        out.print(", ");
                    }
                    out.print((String)entry.getKey() + "=" + entry.getValue());
                    first = false;
                }
                out.print("]");
            }
            if (this.label == null || !this.map.isEmpty()) {
                out.println(";");
            }
        }
    }
}

