/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.fixedwidth;

import java.io.IOException;
import java.io.Writer;
import org.databene.commons.Context;
import org.databene.commons.ConversionException;
import org.databene.commons.SystemInfo;
import org.databene.formats.fixedwidth.FixedWidthRowTypeDescriptor;
import org.databene.formats.script.AbstractScript;
import org.databene.formats.script.Script;
import org.databene.formats.script.ScriptException;
import org.databene.formats.script.ScriptUtil;
import org.databene.formats.script.ScriptedDocumentWriter;

public class ArrayFixedWidthWriter<E>
extends ScriptedDocumentWriter<E[]> {
    public ArrayFixedWidthWriter(Writer out, FixedWidthRowTypeDescriptor descriptor) {
        this(out, (Script)null, (Script)null, descriptor);
    }

    public ArrayFixedWidthWriter(Writer out, String headerScriptUrl, String footerScriptUrl, FixedWidthRowTypeDescriptor descriptor) throws IOException {
        this(out, headerScriptUrl != null ? ScriptUtil.readFile(headerScriptUrl) : null, footerScriptUrl != null ? ScriptUtil.readFile(footerScriptUrl) : null, descriptor);
    }

    public ArrayFixedWidthWriter(Writer out, Script headerScript, Script footerScript, FixedWidthRowTypeDescriptor descriptors) {
        super(out, headerScript, new ArrayFixedWidthScript(descriptors), footerScript);
    }

    private static class ArrayFixedWidthScript
    extends AbstractScript {
        private FixedWidthRowTypeDescriptor descriptor;

        public ArrayFixedWidthScript(FixedWidthRowTypeDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public void execute(Context context, Writer out) throws IOException, ScriptException {
            try {
                Object[] cellsOfCurrentRow = (Object[])context.get("part");
                out.write(this.descriptor.formatArray(cellsOfCurrentRow));
                out.write(SystemInfo.getLineSeparator());
            }
            catch (ConversionException e) {
                throw new ScriptException(e);
            }
        }
    }
}

