/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.fixedwidth;

import java.io.IOException;
import java.io.Writer;
import org.databene.commons.Context;
import org.databene.commons.ConversionException;
import org.databene.commons.Converter;
import org.databene.commons.SystemInfo;
import org.databene.commons.bean.BeanToPropertyArrayConverter;
import org.databene.commons.converter.ArrayConverter;
import org.databene.commons.converter.ConverterChain;
import org.databene.commons.converter.FormatFormatConverter;
import org.databene.commons.converter.ToStringConverter;
import org.databene.formats.fixedwidth.FixedWidthColumnDescriptor;
import org.databene.formats.script.AbstractScript;
import org.databene.formats.script.Script;
import org.databene.formats.script.ScriptException;
import org.databene.formats.script.ScriptUtil;
import org.databene.formats.script.ScriptedDocumentWriter;

public class BeanFixedWidthWriter<E>
extends ScriptedDocumentWriter<E> {
    public BeanFixedWidthWriter(Writer out, FixedWidthColumnDescriptor ... descriptors) {
        this(out, (Script)null, (Script)null, descriptors);
    }

    public BeanFixedWidthWriter(Writer out, String headerScriptUrl, String footerScriptUrl, FixedWidthColumnDescriptor ... descriptors) throws IOException {
        this(out, headerScriptUrl != null ? ScriptUtil.readFile(headerScriptUrl) : null, footerScriptUrl != null ? ScriptUtil.readFile(footerScriptUrl) : null, descriptors);
    }

    public BeanFixedWidthWriter(Writer out, Script headerScript, Script footerScript, FixedWidthColumnDescriptor ... descriptors) {
        super(out, headerScript, new BeanFixedWidthScript(descriptors), footerScript);
    }

    private static class BeanFixedWidthScript
    extends AbstractScript {
        private Converter<Object, String[]> converter;

        public BeanFixedWidthScript(FixedWidthColumnDescriptor[] descriptors) {
            int length = descriptors.length;
            String[] propertyNames = new String[length];
            Converter[] propertyConverters = new Converter[length];
            for (int i = 0; i < length; ++i) {
                FixedWidthColumnDescriptor descriptor = descriptors[i];
                propertyNames[i] = descriptor.getName();
                propertyConverters[i] = new ConverterChain(new Converter[]{new ToStringConverter(), new FormatFormatConverter(String.class, descriptor.getFormat(), true)});
            }
            this.converter = new ConverterChain(new Converter[]{new BeanToPropertyArrayConverter(propertyNames), new ArrayConverter(Object.class, String.class, propertyConverters)});
        }

        @Override
        public void execute(Context context, Writer out) throws IOException, ScriptException {
            try {
                String[] cells = (String[])this.converter.convert(context.get("part"));
                for (int i = 0; i < cells.length; ++i) {
                    out.write(cells[i]);
                }
                out.write(SystemInfo.getLineSeparator());
            }
            catch (ConversionException e) {
                throw new ScriptException(e);
            }
        }
    }
}

