/*
 * Decompiled with CFR 0.152.
 */
package org.databene.formats.fixedwidth;

import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import org.databene.commons.BeanUtil;
import org.databene.commons.format.PadFormat;
import org.databene.formats.DataContainer;
import org.databene.formats.fixedwidth.FixedWidthColumnDescriptor;
import org.databene.formats.fixedwidth.FixedWidthLineIterator;
import org.databene.formats.fixedwidth.FixedWidthRowTypeDescriptor;
import org.databene.formats.fixedwidth.FixedWidthUtil;
import org.databene.formats.util.DataIteratorAdapter;

public class FixedWidthBeanIterator<E>
extends DataIteratorAdapter<String[], E> {
    private Class<E> beanClass;
    private FixedWidthColumnDescriptor[] columnDescriptors;
    private Locale locale = Locale.US;

    public FixedWidthBeanIterator(String uri, String encoding, Class<E> beanClass, String columnFormats) throws IOException, ParseException {
        this(uri, encoding, beanClass, columnFormats, "");
    }

    public FixedWidthBeanIterator(String uri, String encoding, Class<E> beanClass, String columnFormats, String nullString) throws IOException, ParseException {
        super(null);
        this.beanClass = beanClass;
        FixedWidthRowTypeDescriptor rowDescriptor = FixedWidthUtil.parseBeanColumnsSpec(columnFormats, beanClass.getSimpleName(), nullString, this.locale);
        this.columnDescriptors = rowDescriptor.getColumnDescriptors();
        PadFormat[] formats = (PadFormat[])BeanUtil.extractProperties((Object[])this.columnDescriptors, (String)"format", PadFormat.class);
        this.source = new FixedWidthLineIterator(uri, formats);
    }

    @Override
    public Class<E> getType() {
        return this.beanClass;
    }

    @Override
    public DataContainer<E> next(DataContainer<E> container) {
        DataContainer wrapper = this.nextOfSource();
        if (wrapper == null) {
            return null;
        }
        String[] cells = (String[])wrapper.getData();
        Object result = BeanUtil.newInstance(this.beanClass);
        for (int i = 0; i < this.columnDescriptors.length; ++i) {
            BeanUtil.setPropertyValue((Object)result, (String)this.columnDescriptors[i].getName(), (Object)cells[i], (boolean)true, (boolean)true);
        }
        return container.setData(result);
    }
}

